(* multiplication of two p-adic integers *)
(* calculates i * j + c *)
(* the carry-over c is itself a p-adic integer *)
(* TODO: if the integer is 0, optimize *)

open Common
module A = Common.Algebra
type variable = A.variable
type 'b f = 'b A.f
let fh = A.fh
type equation = A.equation
type algebra = A.algebra
let alpha = A.alpha
let solve = A.solve

module Corecursive_Addi = Corecursive.Corecursive(Addi)
module Corecursive_Mult1 = Corecursive.Corecursive(Mult1)
module Corecursive_Equal = Corecursive.Corecursive(Equal)
let addi p i j = Corecursive_Addi.main (p, i, j, 0)
let mult1 p i j = Corecursive_Mult1.main (p, i, j, 0)
let equal i j = Corecursive_Equal.main (i, j)

type coalgebra = int (* p *) * int ilist * int ilist * 
                 int ilist (* carry-over *)
let equal (p1, i1, j1, c1) (p2, i2, j2, c2) =
  p1 = p2 && (equal_ilist i1 i2) && 
  (equal_ilist j1 j2) && (equal c1 c2)
let rec gamma (p, i, j, c) = match j with
  | Nil -> I1 c
  | Cons(hj, tj) -> 
    match (addi p (mult1 p i hj) c) with
      | Nil -> I1 Nil
      | Cons(hres, tres) -> I2 (hres, (p, i, !tj, !tres))
