(* sum of a p-adic integer i with an integer j in [| 0 ; p-1 |] *)
(* calculates i * j + c *)
(* TODO: if the integer is 0, optimize *)

open Common
module A = Common.Algebra
type variable = A.variable
type 'b f = 'b A.f
let fh = A.fh
type equation = A.equation
type algebra = A.algebra
let alpha = A.alpha
let solve = A.solve

type coalgebra = int (* p *) * int ilist * int (* j *) * int (* carry-over *)
let equal (p1, i1, j1, c1) (p2, i2, j2, c2) =
  p1 = p2 && (equal_ilist i1 i2) && j1 = j2 && c1 = c2
let rec gamma (p, i, j, c) = match i with
  | Nil -> if c = 0 then I1 Nil
                    else I2 (c mod p, (p, Nil, j, c/p))
  | Cons(hi, ti) -> let res = hi * j + c in 
      I2 (res mod p, (p, !ti, j, res / p))
