(* given a and b, converts a/b to a p-adic integer, assuming b and p are
   prime together *)

open Common
module A = Common.Algebra
type variable = A.variable
type 'b f = 'b A.f
let fh = A.fh
type equation = A.equation
type algebra = A.algebra
let alpha = A.alpha
let solve = A.solve

type coalgebra = int * int * int (* p, a, b *)
let equal (p1, a1, b1) (p2, a2, b2) =
  p1 = p2 && a1 = a2 && b1 = b2

let gamma (p, a, b) =
(* equation a = b * (d0 + d1 * p + d2 * p^2 +... ) *)
  if a = 0 then I1 Nil (* all the di are 0 *)
  else let d = euclid p a b in (* take the equation modulo p and find d0 *)
       I2 (d, (p, (a - b * d) / p, b)) (* replace d0 and divide equation by p *)