(* equality of two ilists *)

open Common

type variable = string
type 'b f = IT | IF | IC of 'b
let fh (h: 'c * 'e -> 'a * 'e) : 'c f * 'e -> 'a f * 'e =
  function (cf, e) -> match cf with
    | IT -> IT, e
    | IF -> IF, e
    | IC c -> let a, e2 = h(c, e) in IC a, e2

type equation = variable * (variable f)
type coalgebra = int ilist * int ilist
type algebra   = bool

let equal (a1, b1) (a2, b2) = (a1 == a2) && (b1 == b2)

let gamma = function
  | Nil, Nil -> IT
  | Cons(h1, t1), Cons(h2, t2) -> if h1 = h2 then IC(!t1, !t2) else IF
  | Nil, Cons(0, t) -> IC(Nil, !t)
  | Cons(0, t), Nil -> IC(!t, Nil)
  | _ -> IF
let alpha = function
  | IT -> true
  | IF -> false
  | IC b -> b

let rec solve_aux name eqs (seen : variable list) =
  if List.mem name seen then true else
  match List.assoc name eqs with
    | IT -> true | IF -> false
    | IC(name2) -> solve_aux name2 eqs (name :: seen)
let solve name eqs = solve_aux name eqs [ ]