(* takes a p-adic integer i
   returns None if equal to zero
   returns Some(j, n) if it is equal to j followed by n zeros, and the 
                      last digit of j is non-zero *)

open Common

type variable = string
type 'b f = I1 | I2 of 'b | I3 of int ilist
  (* in the case of I3, no recursive call *)
let fh (h: 'c * 'e -> 'a * 'e) 
      : 'c f * 'e -> 'a f * 'e = function
    | I1, e -> I1, e
    | I2(c), e -> 
      let a, e0 = h(c, e) in (I2(a), e0)
    | I3(c), e -> I3(c), e

type equation = variable * (variable f)
type coalgebra = int ilist
type algebra = (int * int ilist) option

let equal = (==)

let gamma = function
  | Nil -> I1 (* definitely zero *)
  | Cons(0, t) -> I2(!t) (* not too sure yet *)
  | i -> I3(i) (* definitely not zero *)
let alpha = function
  | I1 -> None
  | I2(None) -> None
  | I2(Some(n, i)) -> Some(n+1, i)
  | I3(i) -> Some(0, i)

let rec solve_aux name eqs (seen : variable list) =
  if List.mem name seen then None else (* if it loops then it's zero *)
  match List.assoc name eqs with
    | I1 -> None | I3(i) -> Some(0, i)
    | I2(name2) -> 
      (match solve_aux name2 eqs (name :: seen) with
        | None -> None
        | Some(n, i) -> Some(n+1, i)
      )
let solve name eqs = solve_aux name eqs [ ]