(* division of two p-adic integers: i divided by j
   such that j cannot be divided by p: then it returns an integer *)

open Common
module A = Common.Algebra
type variable = A.variable
type 'b f = 'b A.f
let fh = A.fh
type equation = A.equation
type algebra = A.algebra
let alpha = A.alpha
let solve = A.solve

module Corecursive_From_rational = Corecursive.Corecursive(From_rational)
module Corecursive_Addi          = Corecursive.Corecursive(Addi)
module Corecursive_Mult1         = Corecursive.Corecursive(Mult1)
module Corecursive_Multi         = Corecursive.Corecursive(Multi)
let addi p i j = Corecursive_Addi.main (p, i, j, 0)
let mult1 p i j = Corecursive_Mult1.main (p, i, j, 0)
let multi p i j = Corecursive_Multi.main (p, i, j, Nil)

let minus_one p = Corecursive_From_rational.main (p, -1, 1)
let minusi p i j = (* of p-adic integers *)
  addi p i (multi p (minus_one p) j)

module Corecursive_To_string     = Corecursive.Corecursive(To_string)

type coalgebra = int (* p *) * int ilist (* i *) * int ilist (* j *)
  (* calculating i divided by j *)

module Corecursive_Equal = Corecursive.Corecursive(Equal)
let equal i j = Corecursive_Equal.main (i, j)
let equal (p1, i1, j1) (p2, i2, j2) =
  p1 = p2 && (Corecursive_Equal.main (i1, i2)) && (equal_ilist j1 j2)
(* It is necessary to use the module Corecursive_Equal because i is rebuilt
   at each loop *)
let gamma (p, i, j) = match i, j with
  | _, Nil -> failwith "Cannot divide by zero" 
    (* TODO: see what happens with more suddle zeros *)
  | Nil, _ -> I1 Nil
  | Cons(hi, ti), Cons(hj, tj) ->
    let d = euclid p hi hj in (* hi = (hj * d) mod p *)
    match minusi p i (mult1 p j d) with
      | Nil -> I2(d, (p, Nil, j)) (* still need to return the last digit *)
      | Cons(0, t) -> I2(d, (p, !t, j))
      | _ -> assert false