type 'a ilist = Nil | Cons of 'a * 'a ilist ref

type ('i, 'b) func = I1 of 'i ilist | I2 of 'i * 'b
let funch (h: 'c * 'e -> 'a * 'e) : ('i, 'c) func * 'e -> ('i, 'a) func * 'e =
  function (cf, e) -> match cf with
    | I1 i -> I1 i, e
    | I2 (i, c)  -> let a, e2 = h(c, e) in I2 (i, a), e2

let equal_ilist i1 i2 =
  match i1, i2 with
    | Nil, Nil -> true
    | Cons(h1, t1), Cons(h2, t2) -> h1 = h2 && !t1 == !t2
    | _ -> false

let rec build_ilist_aux 
  (name : string)
  (eqs  : (string * ('a, string) func) list) (* None means empty *)
  (seen : (string * 'a ilist) list) : 'a ilist * (string * 'a ilist) list =
  try List.assoc name seen, seen 
  with Not_found ->
    match List.assoc name eqs with
      | I1 i -> (i, seen)
      | I2(h, vt) ->
        let rec res = Cons(h, t)
        and t = ref res in
        let seen0 = (name, res)::seen in
        let (t', seen1) = build_ilist_aux vt eqs seen0 in t := t';
        (res, seen1)
let build_ilist name eqs = fst (build_ilist_aux name eqs [ ])

module Algebra = struct
  type variable = string

  type 'b f = (int, 'b) func
  let fh = funch

  type equation  = variable * (variable f)
  type algebra   = int ilist (* just the integer part of the p-adic number *)

  let alpha = function
    | I1 i -> i
    | I2 (h, t) -> Cons(h, ref t)

  let solve = build_ilist
end

let rec euclid p a b =
(* assumes b and p prime together
   finds d in [| 0 ; p-1 |] such that a = (b * d) mod p
   i.e. there exists e st b * d + p * e = a *)
(* Look up Euclid's algo, but for now brute force: *)
   let a = if a >= 0 then a mod p else a mod p + p in
   let rec tryn d =
     if d < p then 
        (if (b * d) mod p = a then d else tryn (d+1))
     else failwith ((string_of_int b) ^ " and " ^ (string_of_int p) ^
                    " not prime together")
   in tryn 0

let string_of_int2 i =
  if i >= 0 && i < 10 then string_of_int i
  else if i < 36 then Char.escaped(char_of_int(i+55)) (* so 10 is A etc. *)
  else "[" ^ (string_of_int i) ^ "]"
