(* sum of two padic integers *)

open Common
module A = Common.Algebra
type variable = A.variable
type 'b f = 'b A.f
let fh = A.fh
type equation = A.equation
type algebra = A.algebra
let alpha = A.alpha
let solve = A.solve

type coalgebra = int (* p *) * int ilist * int ilist * int (* carry-over *)
let equal (p1, i1, j1, c1) (p2, i2, j2, c2) =
  p1 = p2 && (equal_ilist i1 i2) && (equal_ilist j1 j2) && c1 = c2
let rec gamma (p, i, j, c) = match i, j with
  | Nil, Nil -> if c = 0 then I1 Nil
                         else I2 (c mod p, (p, Nil, Nil, c/p))
  | Cons(h, t), Nil | Nil, Cons(h, t) ->
                         gamma (p, Cons (h,t), Cons(0, ref Nil), c)
  | Cons(hi, ti), Cons(hj, tj) -> let res = hi + hj + c in 
      I2 (res mod p, (p, !ti, !tj, res / p))
