open Corecursive;;

(*
            h
      C ----------> A
      |             ^
gamma |             | alpha
      v     F h     |
     F C --------> F A
*)

(*********************************)
print_string "Fv"; print_newline();;
(*********************************)
module Corecursive_Fv = Corecursive(Fv);;

let rec t1 = Fv.App(Fv.Var("x"), t1);;
let rec t2 = Fv.App(Fv.Var("x"), Fv.App(Fv.Var("x"), t2));;
let rec t3 = Fv.App(Fv.Var("x"), t1);;
let rec t4 = Fv.App(Fv.Var("x"), Fv.App(Fv.Var("y"), t4));;

let string_of_list f l =
  ("[ " ^ (String.concat " ; " (List.map f l)) ^ " ]\n");;
let string_of_string_list = string_of_list (fun x -> x);;

Fv.VarSet.elements(Corecursive_Fv.main t1);;
print_string(
  string_of_string_list(Fv.VarSet.elements(Corecursive_Fv.main t1)));;
print_string(
  string_of_string_list(Fv.VarSet.elements(Corecursive_Fv.main t2)));;
print_string(
  string_of_string_list(Fv.VarSet.elements(Corecursive_Fv.main t3)));;
print_string(
  string_of_string_list(Fv.VarSet.elements(Corecursive_Fv.main t4)));;

(*******************************************)
print_string "Substitution"; print_newline();
(*******************************************)
module Corecursive_Subst = Corecursive(Substitution);;

Corecursive_Subst.main t1;;
Corecursive_Subst.main t2;;
Corecursive_Subst.main t3;;
Corecursive_Subst.main t4;;

(*******************************************)
print_string "Substitution (Toploop)"; print_newline();
(*******************************************)
module Corecursive_SubstToploop = Corecursive(Subst_toploop);;

Corecursive_SubstToploop.main t1;;
Corecursive_SubstToploop.main t2;;
Corecursive_SubstToploop.main t3;;
Corecursive_SubstToploop.main t4;;

(****************************************)
print_string "Alexandra (Substitution 2)"; print_newline();
(****************************************)
module Corecursive_Alexandra = Corecursive(Alexandra);;

let x = "x";;
let t = Alexandra.S.AppM (ref (Alexandra.S.VarM "y"), ref (Alexandra.S.VarM "y"));;
Corecursive_Alexandra.main t1 (x, t);;
Corecursive_Alexandra.main t2 (x, t);;
Corecursive_Alexandra.main t3 (x, t);;
Corecursive_Alexandra.main t4 (x, t);;

(*********************************)
print_string "Stream"; print_newline();
(*********************************)
module Corecursive_Stream = Corecursive(Stream);;

let rec ones = 1. :: ones;;
let rec zeros_ones = 0. :: 1. :: zeros_ones;;

print_float(Corecursive_Stream.main ones);;
print_newline();;
print_float(Corecursive_Stream.main zeros_ones);;
print_newline();;

(*********************************)
print_string "Probability"; print_newline();
(*********************************)
module Corecursive_Probability = Corecursive(Probability);;

let rec coin1 =
  Probability.Flip(0.5, Probability.Heads, Probability.Flip(0.5, Probability.Tails, coin1));;
print_float(Corecursive_Probability.main coin1);;
print_newline();;

print_string "Flips"; print_newline();
module Corecursive_Flips = Corecursive(Flips);;

print_float(Corecursive_Flips.main coin1);;
print_newline();;

(*********************************)
print_string "Dexter"; print_newline();
(*********************************)
module Corecursive_Dexter = Corecursive(Dexter);;

let rec coin1_Dexter =
  Dexter.Flip(
    0.5,
    function
      | Dexter.Zero -> Dexter.Done Dexter.Heads
      | Dexter.One -> 
	Dexter.Flip(0.5,
		    function
		      | Dexter.Zero -> Dexter.Done Dexter.Tails
		      | Dexter.One -> coin1_Dexter));;

print_float(Corecursive_Dexter.main coin1_Dexter);;
print_newline();;

(*********************************)
print_string "Descending"; print_newline();
(*********************************)
module Corecursive_Descending = Corecursive(Descending);;

let rec stream1 = 3::2::1::4::stream1;;

(*
  let rec var1 = var2
  and var2 = var3
  and var3 = 3 :: var4
  and var4 = var5
  and var5 = var6
  and var6 = var7
  and var7 = 4 :: var4
  in var1;;

  let rec var1 = 3 :: var4
  and var4 = 4 :: var4
  in var1;;
*)

let _ = Corecursive_Descending.main (1, stream1);;
print_newline();;

(*********************************)
print_string "Outcome"; print_newline();
(*********************************)
module Corecursive_Outcome = Corecursive(Outcome);;

let _ = Corecursive_Outcome.main coin1;;

(*********************************)
print_string "Equality"; print_newline();
(*********************************)
module Corecursive_Equality = Corecursive(Equality);;

let rec ones = 1 :: ones;;
let rec ones' = 1 :: ones';;
let rec ones'' = 1 :: 1 :: ones'';;
let rec ones''' = 1 :: 1 :: 1 :: ones''';;
let rec not_ones = 1 :: 1 :: 1 :: 2 :: ones;;

let print_bool b = print_string (if b then "true" else "false");
print_newline();;

print_bool (Corecursive_Equality.main (ones, ones'));
print_bool (Corecursive_Equality.main (ones, ones''));
print_bool (Corecursive_Equality.main (ones, not_ones));
print_bool (Corecursive_Equality.main (ones'', ones''')); (* 6 comparisons performed! *)

(*********************************)
print_string "Abstract interpretation"; print_newline();
(*********************************)
module Corecursive_Ai = Corecursive(Ai);;

(*
module A = Ai_naive;;

A.print_astore (A.join_env [] []);;
A.print_astore (A.join_env ["x", A.AFalse] []);;
A.print_astore (A.join_env ["x", A.AFalse; "y", A.AFalse; "z", A.AFalse]
                           ["x", A.ATrue; "y", A.ATrue]);;
*)

Ai.Naive.print_astore (Corecursive_Ai.main [ "x", Ai.Naive.ATrue; "y", Ai.Naive.AFalse ]);;
(* Rq: if you put while(true) the out environment is empty,
       (actually it's the environment given as initial input)
       which is a valid result in some sense *)

(*********************************)
print_string "Gaussian"; print_newline();
(*********************************)
let solve_x e = print_string(string_of_float(Gaussian.solve "x" e) ^ "\n") in
  solve_x [["x", 1.], 1.];
  solve_x [["x", 2.], 1.];
  solve_x [["x", 2.; "y", 3.], -11. ; ["x", 3.; "y", -1.], 0.];
  flush_all ();
  (* solve_x [["x", 2.], -3. ; ["x", 3.], 0.];; *) (* no solution *)
  solve_x [["x", 1.; "y", -2.; "z", -1.], 0.;
           ["y", 1.; "z", -3.], 0.;
           ["z", 1.; "x", -5.], 238. ];;

(*********************************)
print_string "Finite"; print_newline();;
(*********************************)
let l1 = [ 4; 5 ];;
let rec l2 = 0 :: l2;;
let l3 = 1 :: l2;;

module Corecursive_Finite = Corecursive(Finite);;

print_bool (Corecursive_Finite.main l1);;
print_bool (Corecursive_Finite.main l2);;
print_bool (Corecursive_Finite.main l3);;

(***********************************)
print_string "p-adic"; print_newline();;
(***********************************)
module Corecursive_From_rational = Corecursive(From_rational);;
module Corecursive_To_string        = Corecursive(To_string);;

let from_q p a b =
  let n = Corecursive_From_rational.main (p, a, b) in
  print_string(let r, nr = Corecursive_To_string.main n
               in "(" ^ r ^ ")" ^ nr); print_newline();;  
from_q 5 (-1) 1;;
from_q 5 1 2;;

Padic.print (Padic.from_rational 5 23 125);
Padic.print (Padic.from_rational 7 12 35);;

print_newline();;

let print_both a = 
  Padic.print a; print_string " = "; 
  print_string (string_of_float (Padic.to_float a)); print_newline ();;

(* Padic.from_rational base numerator denominator *)
let a = Padic.from_rational 7 345 10 and b = Padic.from_rational 7 34 3 in
print_both a;
print_both b;
print_both (Padic.add a b);
print_both (Padic.mult a b);
print_both (Padic.div a b);; (* is it just a rounding error ?? *)

print_newline();

let a = Padic.from_rational 7 15 7 and b = Padic.from_rational 7 5 7 in
print_both a;
print_both b;
print_both (Padic.add a b);
print_both (Padic.mult a b);
print_both (Padic.div a b);;

print_newline();

let a = Padic.from_rational 7 23 5 and b = Padic.from_rational 7 42 1 in
print_both a;
print_both b;
print_both (Padic.add a b);
print_both (Padic.mult a b);
print_both (Padic.div a b);;

print_newline();

let rec l = 0 :: 1 :: 0 :: 1 :: l in
let a = Padic.from_lists 2 l [ ] in
print_both a;
print_both (Padic.normalize a);;

print_newline();

let rec l = 0 :: 0 :: 0 :: l in
let a = Padic.from_lists 2 l [ ] in
print_both a;
print_both (Padic.normalize a);;

let rec l = 0 :: 1 :: 0 :: 1 :: l in
let a = Ifloat.from_lists 10 false [ 5; 4; 3 ] l in
Ifloat.print a;

let a = Ifloat.from_lists 10 false [ ] l in
Ifloat.print (Ifloat.add a a);

let a = Ifloat.from_lists 2 false [ ] l in
Ifloat.print (Ifloat.add a a);;

let rec l4 = 4 :: l4 in
let rec l5 = 5 :: l5 in
let i4 = Ifloat.from_lists 10 false [] l4 in
let i5 = Ifloat.from_lists 10 false [] l5 in
Ifloat.print (Ifloat.normalize (Ifloat.add i4 i5));
Ifloat.print (Ifloat.add i5 i5);
Ifloat.print (Ifloat.add i4 i4);;

let rec l4 = 4 :: 4 :: 3 :: 4 :: l4 in
let rec l5 = 5 :: l5 in
let i4 = Ifloat.from_lists 10 false [] l4 in
let i5 = Ifloat.from_lists 10 false [] l5 in
Ifloat.print (Ifloat.add i4 i5);;

let rec l4 = 5 :: 4 :: l4 in
let rec l5 = 5 :: 5 :: l5 in
let i4 = Ifloat.from_lists 10 false [] l4 in
let i5 = Ifloat.from_lists 10 false [] l5 in
Ifloat.print (Ifloat.add i4 i5);
Ifloat.print (Ifloat.normalize (Ifloat.add i5 i5));
Ifloat.print (Ifloat.add i4 i4);;

let rec l9 = 9 :: 9 :: l9 in
let i9 = Ifloat.from_lists 10 false [] l9 in
Ifloat.print (Ifloat.normalize i9);
let i9 = Ifloat.from_lists 10 false [ 9 ; 9 ; 9 ] l9 in
Ifloat.print (Ifloat.normalize i9);;

let rec l7 = 7 :: 8 :: l7 in
let rec l8 = 8 :: l8 in
let i7 = Ifloat.from_lists 16 false [] l7 in
let i8 = Ifloat.from_lists 16 false [] l8 in
Ifloat.print (Ifloat.add i7 i8);
Ifloat.print (Ifloat.normalize (Ifloat.add i7 i7));
Ifloat.print (Ifloat.add i8 i8);;


