(* An alternate way of doing padic/to_string                        *)
(* returns lists of digits instead of strings, easier to manipulate *)
(* from an i list [ 3; 5; 1; 3; 1; 3; 1; 3; 1; 3; 1 ...] returns:
   - the non-repeating part [ 3; 5; 1 ]
   - the nonrepeating part [ 3; 1 ], based on the structure in memory *)

open Common

type variable = string
type 'b f = I1 | I2 of int * 'b


let fh (h: 'c * 'e -> 'a * 'e) : 'c f * 'e -> 'a f * 'e =
  function (cf, e) -> match cf with
    | I1 -> I1, e
    | I2 (i, c)  -> let a, e2 = h(c, e) in I2 (i, a), e2

type equation = variable * (variable f)
type coalgebra = int ilist
type algebra   = int list * int list

let equal = (==)

let gamma = function
  | Nil -> I1
  | Cons(i, t) -> I2(i, !t)
(* let alpha?? *)
(* maybe this module is cheating?? *)

let rec remove_beginning l pref = match l, pref with
  (* pref should be a prefix of l *)
  | _, [ ] -> l
  | hl :: tl, hp :: tp when hl = hp -> remove_beginning tl tp
  | _ -> failwith "pref not a prefix of l"

let rec solve_aux name eqs (seen : (variable * int list) list) (sofar : int list) =
  try let e = List.rev (List.assoc name seen) in
    e, remove_beginning (List.rev sofar) e
  with Not_found -> match List.assoc name eqs with
    | I1 -> List.rev sofar, [ ]
    | I2(i, name2) -> let res = i :: sofar in
        solve_aux name2 eqs ((name, sofar) :: seen) res

let solve name eqs = solve_aux name eqs [ ] [ ]

