module C = Common
module P = Padic

type ifloat = int * bool * int list * int C.ilist
(* base, negative sign, before dot (in reverse order), after dot *)

module Corecursive_Fnormalize      = Corecursive.Corecursive(Fnormalize)
module Corecursive_Equal          = Corecursive.Corecursive(Equal)
module Corecursive_From_list      = Corecursive.Corecursive(From_list)
module Corecursive_To_lists       = Corecursive.Corecursive(To_lists)
module Corecursive_Addf           = Corecursive.Corecursive(Addf)

let rec equal (p1, s1, i1, j1) (p2, s2, i2, j2) =
  if p1 != p2 then
    failwith "Cannot compare p-adic numbers in two different bases"
  else
    (i1 = i2) && (s1 = s2) && (Corecursive_Equal.main (j1, j2))

let from_lists p b (i : int list) (j : int list) =
  (p, b, i, Corecursive_From_list.main j)

let rec add_int_part p i1 i2 c = match i1, i2 with
  | [], [] -> if c = 0 then [ ] else if c = 1 then [ 1 ] else assert false
  | h :: t, [] | [], h :: t -> 
    if c = 0 then h :: t else add_int_part p (h :: t) [ c ] 0
  | h1 :: t1, h2 :: t2 ->
    let d = h1 + h2 + c in
    (d mod p) :: (add_int_part p t1 t2 (d/p))

let rec normalize (p, s, i, j) =
  let rec nines = C.Cons(p-1, ref nines) in
  if Corecursive_Equal.main (j, nines) then (p, s, add_int_part p i [] 1, C.Nil)
  else (p, s, i, Corecursive_Fnormalize.main (p, j))

let shift n (p, s, i, j) = (* multiplies i by p^n *)
  let (_, jres, ires) = Padic.shift (-n) (p, j, i) in
  (p, s, ires, jres)

let rec from_int p i =
  let rec aux = function
  | 0 -> [ ]
  | n when n > 0 -> (n mod p) :: (aux (n/p))
  | _ -> assert false
  in 
  if i < 0 then (p, true, aux (-i), C.Nil)
  else (p, false, aux i, C.Nil)

let to_string (p, s, i, j) =
  let bc = String.concat "" (List.rev (List.map C.string_of_int2 i)) in
  let nrl, rl = Corecursive_To_lists.main j in
  let nr = String.concat "" (List.map C.string_of_int2 nrl) in
  let r  = String.concat "" (List.map C.string_of_int2 rl ) in
  let prefix = (if s then "-" else "") ^ (if bc = "" then "0" else bc) ^ "." in
  ((if r = "" then prefix ^ nr
   else prefix ^ nr ^ r ^ r ^ r ^ "..." ^ " = " ^
        prefix ^ nr ^ "(" ^ r ^ ")")
  ^ " (base " ^ (string_of_int p) ^ ")")

let print f = print_string (to_string f); print_newline()

let add (p1, s1, i1, j1) (p2, s2, i2, j2) =
  if p1 != p2 then
    failwith "Cannot add p-adic numbers in two different bases"
  else
    let p = p1 in
  if s1 = s2 then
    let (c, j) = Corecursive_Addf.main (p, j1, j2) in
    let i = add_int_part p i1 i2 c in
    (p, s1, i, j)
  else failwith "TODO" (* needs a substraction *)