open Common
module A = Common.Algebra
type variable = A.variable
type 'b f = 'b A.f
let fh = A.fh
type equation = A.equation
type algebra = A.algebra
let alpha = A.alpha
let solve = A.solve

module Corecursive_Equal = Corecursive.Corecursive(Equal)
let equal_ilist i j = Corecursive_Equal.main (i, j)

type coalgebra = int (* p *) * int ilist
let equal (p, i) (q, j) = (p = q) && equal_ilist i j
(* very important! equal_ilist would not normalize anything!! *)

let rec gamma (p, l) =
  let rec nines = Cons(p-1, ref nines) in
  match l with
  | Nil -> I1 Nil
  | i when equal_ilist i Nil -> I1 Nil
  | i when equal_ilist i nines -> assert false
  | Cons(i, t) when equal_ilist !t nines -> I1 (Cons(i+1, ref Nil))
  | Cons(h, t) -> I2(h, (p, !t))
