(* sum of two floating parts                *)
(* returns a floating part and a carry-over *)

open Common

type variable = string

type 'b f = I1 of int ilist | I2 of int * int * 'b
let fh (h: 'c * 'e -> 'a * 'e) : 'c f * 'e -> 'a f * 'e =
  function (cf, e) -> match cf with
    | I1 i -> I1 i, e
    | I2 (i1, i2, c)  -> let a, e2 = h(c, e) in I2 (i1, i2, a), e2

type coalgebra = int (* p *) * int ilist * int ilist
type algebra   = int * int ilist

let equal (p1, i1, j1) (p2, i2, j2) =
  p1 = p2 && equal_ilist i1 i2 && equal_ilist j1 j2

let gamma (p, i, j) = match (i, j) with
 | Nil, Nil -> I1(Nil)
 | Nil, k | k, Nil -> I1(k)
 | Cons(hi, ti), Cons(hj, tj) -> I2(p, hi + hj, (p, !ti, !tj))

let alpha = function
 | I1(l) -> (0, l)
 | I2(p, d0, (c, t)) -> let d = d0 + c in
                            (d/p, Cons((d mod p), ref t))

type equation  = variable * (variable f)


type carry = Known of int | Equal of string

let rec solve_aux (name : variable) eqs
  (seen : (string * carry) list) (last_nine : string option)
  : int (* carry-over *) * int ilist ref (* result *) *
    (string * int ilist ref) option (* patch *) = 
  (* solves for all the carry-overs: a carry-over is either zero or one *)
  (* it is either clearly zero (hi + hj <= p-2) or clearly one (hi + hj >= p) *)
  (* or depends on the previous one; if depend in a loop, can be either all 0 *)
  (* or all 1, cf. 0.99999... = 1. = 0.(5) + 0.(4); we choose to return one *)
  try let res = ref Nil in
      (* Nil does not matter, it's a dummy, will be patched later *)
    match List.assoc name seen with
      | Known(c) -> (c, res, Some(name, res))
      | Equal(s0) -> ( match last_nine with 
         | Some(s1) when s1 = s0 (* it looped *) -> (1, res, Some(name, res))
           (* if returning 0, we choose 999...;if returning 1 we choose 000...*)
         | _ -> assert false (* It should have been suppressed at (***) *) )
  with Not_found ->
    match List.assoc name eqs with
    | I1 l -> (0, ref l, None)
    | I2(p, d0, tname) ->
      let (res, carry0, patch) = (
        if d0 = p-1 (* only case where the carry is not determined *)
        then
          let (remember, tlast_nine) = (match last_nine with
            | None -> Equal(name), Some(name)
            | Some(l) -> Equal(l), Some(l)) in
          let (carry, tail, patch) =
            solve_aux tname eqs ((name, remember) :: seen) tlast_nine in
          let d1 = d0 + carry in
          let res = Cons( d1 mod p, tail) in
          (res, carry (* = d1 / p *), patch)
        else 
          let carry0 = if d0 < p-1 then 0 else 1 in
          let (tseen, tlast_nine) = (match last_nine with
            | None -> (name, Known(carry0)) :: seen, None
            | Some(l) -> 
               (name, Known(carry0)) :: (l, Known(carry0)) :: seen, (***)
               None) in
          let (carry, tail, patch) =
            solve_aux tname eqs tseen tlast_nine in
          let d1 = d0 + carry in
          let res = Cons( d1 mod p, tail ) in
          (res, carry0 (* = d1 / p *), patch)
        ) in
        let patch0 =
          (match patch with None -> None
           | Some(s, r) -> if s = name then (r := res; None) else patch) in  
        if carry0 <> 0 && carry0 <> 1 then assert false else (* just checking *)
        carry0 (* = d1 / p *), ref res, patch0

let solve name eqs =
  match solve_aux name eqs [ ] None with
  | a, b, None -> a, !b
  | _ -> assert false

(*
let's add 

0.(54)
and 
0.(55)

2 : 1.09
4 : 1.1009
6 : 1.101009
8 : 1.10101009 etc.

thus conjecture: = 1.1010101010101010...09

can you prove it?
sum_{i=1}^{oo} 54 x 10^{-2 * i} + sum_{i=1}^{oo} 55 x 10^{-2 * i}
= sum_{i=1}^{oo} 109 x 10^{-2 * i}
= sum_{i=1}^{oo} 100 x 10^{-2 * i} + sum_{i=1}^{oo} 9 x 10^{-2 * i}
= 1 + sum_{i=2}^{oo} 100 x 10^{-2 * i} + sum_{i=1}^{oo} 9 x 10^{-2 * i}
= 1 + sum_{i=1}^{oo} 1 x 10^{-2 * i} + sum_{i=1}^{oo} 9 x 10^{-2 * i}
= 1 + sum_{i=1}^{oo} 10 x 10^{-2 * i}
= 1.(10)                              QED

rank 0, 1, 2

1.(87)

(base 10)  results (ci, li)
c1 = (5+5+c2) / 10
l1 = ( (5+5+c2) mod 10 ) :: l2
c2 = (5+4+c1) / 10
l2 = ( (5+4+c1) mod 10 ) :: l1

from c1 def, c1 > 1 so c1 = 1
then from c2 def, c2 =1


but now let's look at 
0.(5)
0.(4)
result 0.(9) = 1.
c1 = (4+5+c1) / 10
l1 = ((4+5+c1) mod 10) :: l1

Both 0 and 1 are solutions for the equation on c1!!
which gives the two solutions...
*)