(*****************)
(* Generating fh *)
(*****************)
type functor_type = string * string * (string * string list) list;;

(*   type 'b f = I1 of variable | I2 of 'b * 'b;; *)
let fv_type = "'b", "f", [
  ( "I1", [ "string" ] );
  ( "I2", [ "'b" ; "'b" ] )   (* really, just need to know if = to parameter or not *)
  ];;
let a_type = "'a", "f", [
  ( "I1", [ "string"; "'a"; "int"; "'a" ] );
  ( "I2", [ "float"; "'a"; "float" ] )
  ];;

let fresh =
  let c = ref 0 in
  fun () -> c := !c + 1; (string_of_int (!c));;

(* could fold in case of a Ii of 'b list ... *)
let generate_fh ((b, f, l) : functor_type) : string =
  "type " ^ b ^ " " ^ f ^ " =\n" ^
  (String.concat "\n" (List.map (fun (constructor, args) ->
                        " | " ^ constructor ^ " of " ^ (String.concat " * " args)) l)
  )
  ^ "\n\n" ^
  "let fh (h: 'c * 'e -> 'a * 'e)\n" ^
  "  : 'c " ^ f ^ " * 'e -> 'a " ^ f ^ " * 'e = function\n" ^
  (String.concat "\n" (List.map
    (fun (constructor, args) ->
      let e = "e" ^ (fresh()) in
      let l1, s2, l3, ef = 
      List.fold_left
       (fun (pattern, body, result, ecurrent) arg ->
         let fresh = fresh () in
         if arg = b then (
           let ci, ei, ai = "c" ^ fresh, "e" ^ fresh, "a" ^ fresh in
           ci :: pattern, 
           body ^ "    let " ^ ai ^ ", " ^ ei ^ " = h (" ^ ci ^ ", " ^ ecurrent ^ ") in\n",
           ai :: result, ei)
         else 
           (let vi = arg ^ fresh in vi :: pattern, body, vi :: result, ecurrent))
     ([ ], "", [ ], e) args in
      "  | " ^ constructor ^ "(" ^ (String.concat ", " (List.rev l1)) ^ "), " ^ e ^ " -> \n" ^
      s2 ^ "      " ^ constructor ^ "(" ^ (String.concat ", " (List.rev l3)) ^ "), " ^ ef) l) )
  ^ ";;\n";;

print_string (generate_fh fv_type);;
print_newline();;
print_string (generate_fh a_type);;