type var = string
type func = TX | TVar of var 
          | TSum of string * (string * func) list
          | TTuple of func list
(* the var lists are the variables just after the big Lambda *)
type sumtype = (var list) * string * (string * var list) list

type pattern =
 | PVar of var
 | PInj of string * pattern
 (* or just pattern and put a Tuple inside? *)
 | PTuple of pattern list

type expr =
 | Var of var
 | Corec of var * expr
 | Function of (pattern * expr) list
 | App of expr * expr
 (* and not supported inside corecursive: *)
 | Inj of string * expr
 | Tuple of expr list
 | Let of pattern * expr * expr

(* types string, set *)

(* type tree = IVar of string | IApp of tree * tree *)
(*let (tree : sumtype ) = [], "tree", [ "IVar", [ String ];
                                      "IApp", [ TSum "tree"; TSum "tree" ] ]*)
let ( fv : expr ) =
  Corec("fv", Function [
    PInj("IVar", PVar("s")),
      App(Var "singleton", Var "s");
    PInj("IApp", PTuple [PVar "t1"; PVar "t2"]), 
      App(
          App( Var "union",
                App(  Var "fv",
                      Var "t1"  ) ),
          App(  Var "fv",
                Var "t1"  ) )
   ])

(* sorted association list, no doubles *)
let rec insert x = function
 | [ ] -> [ x ] 
 | y :: t when x < y -> x :: y :: t
 | y :: t when x = y -> x :: t
 | y :: t -> y :: insert x t

let fresh =
  let c = ref 0 in
  fun () -> c := !c + 1; (string_of_int (!c))

(* Simplifications:
   - only handles one argument
     (which could be a tuple, when tuples are handled)
*)

let rec merge l1 l2 = match (l1, l2) with
 | [ ], _ -> l2
 | _, [ ] -> l1
 | hd1 :: tl1, hd2 :: tl2 when hd1 = hd2 ->
    hd1 :: (merge tl1 tl2)
 | hd1 :: tl1, hd2 :: tl2 when hd1 < hd2 -> 
    hd1 :: (merge tl1 l2)
 | hd1 :: tl1, hd2 :: tl2 -> hd2 :: (merge l1 tl2)

let rec binds ( p : pattern ) : var list = match p with
| PVar v -> [ v ]
| PInj(_, p) -> binds p
| PTuple l -> 
    List.fold_left (fun res p -> merge res (binds p)) 
                   [ ] l

let rec use_one ( v : var ) ( usable : var list list)
                ( used : var list list) : var list list =
(* usable and used are lists of lists to mark imbricated scopes *)
match usable, used with
| [ ], [ ] -> [ ] (* if v was not usable, we don't care that it was used
                     because it is a global variable *)
| hdusable :: tlusable, hdused :: tlused ->
   if List.mem v hdusable 
   then (insert v hdused) :: tlused
   else hdused :: (use_one v tlusable tlused)
| _ -> assert false (* the number of scopes should be the same in
                       usable and used *)
let use (l : var list) (usable : var list list)
        (used : var list list) : var list list =
List.fold_left (fun used_o v -> use_one v usable used_o)
               used l

type res = 
   Called of expr (* gamma *) * expr (* alpha *) *
             pattern (* pattern to be used for the result of calling gamma *) *
             func (* the type of the functor *)
 | Notcalled
let rec cut ( e : expr ) ( n : string * var )
            (* name of corecursive function *)
            ( usable  : var list list )
            ( used    : var list list )
            (* var list is the list of type variables used *)
            : res * (var list list) = 
            (* will also need to return the functor *)
  let (name, cotyp) = n in (* types of coalgebra for functor *) 
  match e with
 (* only handling single argument for now *)
 | App( Var v, arg ) when v = name
     && not(List.exists (fun u -> List.mem name u) usable) ->
        (* if n was rebound *) (* TODO: optimize this test *)
     (match cut arg n usable used with
      | Notcalled, used1 ->
          let f = fresh () in let r = "r" ^ f in
          Called(arg, Var r, PVar r, TX), 
          used (* NOT used1: the variables called in arg don't need to cross border *)
      | _ -> failwith "Nested corecursive calls not allowed"
     )
 | Var v when v = name
     && not(List.exists (fun u -> List.mem name u) usable) -> 
     failwith "A recursive call has to be applied right away"
 | Var v -> Notcalled, use_one v usable used
 | App( e1, e2 ) -> (* Inj and Pair should be handled similarly *)
      let cut1, used1 = cut e1 n usable used in 
      (* passing used and sumtypes through *)
      let cut2, used2 = cut e2 n usable used1 in 
    ( match cut1, cut2 with
     | Notcalled, Notcalled -> Notcalled
     | Called( g1, a1, p1, func1), Called(g2, a2, p2, func2) ->
         Called( Tuple [ g1; g2 ], App( a1, a2 ), PTuple [ p1; p2 ],
                 TTuple [ func1; func2 ] )
     | Notcalled, Called(g2, a2, p2, func2) -> 
         Called( g2, App( e1, a2 ), p2, func2 )
     | Called(g1, a1, p1, func1), Notcalled ->
         Called( g1, App( a1, e2 ), p1, func1 )
    ), used2
 | Function [ pattern1, expr1; pattern2, expr2 ] ->
    (* Big particularity here: it does create a new scope! *)
    ( let usable1 = (binds pattern1) :: usable in (* adds a scope *)
      let cut1, used1 = cut expr1 n usable1 ([] :: used) in 
      (* passing used through *)
      let usable2 = (binds pattern2) :: usable in
      let cut2, used2 = 
        cut expr2 n usable2 ([] :: List.tl used1) in
      let usedf = List.tl used2 in
      let vars1  = List.map (fun x -> Var x) (List.hd used1)  in
      let patts1 = List.map (fun x -> PVar x) (List.hd used1) in
      let vars2  = List.map (fun x -> Var x) (List.hd used2)  in
      let patts2 = List.map (fun x -> PVar x) (List.hd used2) in
      let typvars1 = List.map (fun x -> TVar("'v" ^ fresh())) (List.hd used1) in
      let typvars2 = List.map (fun x -> TVar("'v" ^ fresh())) (List.hd used2) in
     (match cut1, cut2 with
     | Notcalled, Notcalled -> Notcalled
     | Called(g1, a1, p1, func1), Called(g2, a2, p2, func2) ->
         (* another solution would be to move all the patterns up, but I choose this *)
         let result = "r" ^ fresh() in
         let newkindname = "typ" ^ fresh() in
         let i1 = "I" ^ fresh() and i2 = "I" ^ fresh() in
         Called( Function [ pattern1, Inj(i1, Tuple(g1 :: vars1));
                            pattern2, Inj(i2, Tuple(g2 :: vars2)) ],
                 App( (* really, it's a match *)
                   Function [ PInj(i1, PTuple(p1 :: patts1)), a1 ;
                              PInj(i2, PTuple(p2 :: patts2)), a2 ], 
                   Var result),
                 PVar result,
                 TSum(newkindname, 
                      [ i1, TTuple(func1 :: typvars1); i2, TTuple(func2 :: typvars2) ]))
     | Notcalled, Called(g2, a2, p2, func2) -> (* it would be better if p2 was a pattern list *)
         let result = "r" ^ fresh() in
         let newkindname = "typ" ^ fresh() in
         let i1 = "I" ^ fresh() and i2 = "I" ^ fresh() in
         Called( Function [ pattern1, Inj(i1, Tuple(vars1));
                            pattern2, Inj(i2, Tuple(g2 :: vars2)) ],
                 App( (* really, it's a match *)
                   Function [ PInj(i1, PTuple(patts1)), expr1 ;
                              PInj(i2, PTuple(p2 :: patts2)), a2 ], 
                   Var result),
                 PVar result,
                 TSum(newkindname, 
                      [ i1, TTuple(typvars1); i2, TTuple(func2 :: typvars2) ]))
     | Called(g1, a1, p1, func1), Notcalled ->
         let result = "r" ^ fresh() in
         let newkindname = "typ" ^ fresh() in
         let i1 = "I" ^ fresh() and i2 = "I" ^ fresh() in
         Called( Function [ pattern1, Inj(i1, Tuple(g1 :: vars1));
                            pattern2, Inj(i2, Tuple(vars2)) ],
                 App( (* really, it's a match *)
                   Function [ PInj(i1, PTuple(p1 :: patts1)), a1 ;
                              PInj(i2, PTuple(patts2)), expr2 ], 
                   Var result),
                 PVar result,
                 TSum(newkindname, 
                      [ i1, TTuple(func1 :: typvars1); i2, TTuple(typvars2) ]))
    ), usedf )
 | _ -> failwith "Nested corecursive calls not allowed"   
     
let do_cut = function
  | Corec(n, e) -> 
     (match cut e (n, "'co" ^ fresh()) [ ] [ ] with
     | Called(g, App(f, Var v1), PVar v2, func), [ ] when v1 = v2 ->
         g, f, func (* slight optimization *)
     | Called(g, a, p, func), [ ] -> g, Function [ p, a ], func
     | Notcalled, [ ] -> Function [ PVar "x", Var "x" ], e, TVar("'v" ^ fresh())
     | _ -> assert false)
  | _ -> assert false;;



(*******************)
(** Testing ********)

let rec string_of_pattern = function
| PVar v -> v
| PInj(s, p) -> s ^ (string_of_pattern p)
| PTuple(l) -> "(" ^ (String.concat ", " (List.map string_of_pattern l)) ^ ")"

let rec string_of_expr = function
| Var v -> v
| Corec(f, e) -> "let corec " ^ f ^ " = " ^ (string_of_expr e)
| Function l -> "function " ^
    (String.concat ""
      (List.map
        (fun (p, e) ->
          "\n| " ^ (string_of_pattern p) ^ " -> " ^ (string_of_expr e))
        l))
| App(e1, e2) -> "(" ^ (string_of_expr e1) ^ ") (" ^ (string_of_expr e2) ^ ")"
| Inj(s, a) -> s ^ (string_of_expr a)
| Tuple l -> "(" ^ (String.concat ", " (List.map string_of_expr l)) ^ ")"
| Let(p, d, e) -> "let " ^ (string_of_pattern p) ^ " = " ^ (string_of_expr d) ^
                  " in\n" ^ (string_of_expr e)

let rec string_of_functor_aux (x:string) (func:func) : (string * var list * string) =
match func with
| TX -> "", [ x ], x
| TVar v -> "", [ v ], v
| TTuple l -> 
  let rc = List.map (string_of_functor_aux x) l in
  let sums, vars, strs = List.fold_right 
    (fun (sum, var, str) (sums, vars, strs) -> (sums ^ sum, merge vars var, str :: strs))
    rc ("", [ ], [ ]) in
  sums, vars, "(" ^ (String.concat " * " strs) ^ ")"
| TSum(n, l) ->
  let rc = List.map (fun (i, t) -> (i, string_of_functor_aux x t)) (List.rev l) in
  let sums, vars, cases = List.fold_right
    (fun (i, (sum, var, casei)) (sums, vars, cases) -> (sums ^ sum, merge vars var, 
       (cases ^ "| " ^ i ^ " of " ^ casei ^ "\n"))) rc ("", [ ], "") in
  let varsstr = "(" ^ (String.concat ", " vars) ^ ")" in
  sums ^ "type " ^ varsstr ^ " " ^ n ^ " = \n" ^ cases,
  vars, varsstr ^ " " ^ n
let string_of_functor f =
  let x = "'ax" in
  let (a, b, c) = string_of_functor_aux x f in
  a ^ "\n" ^
  "type (" ^ (String.concat ", " b) ^ ") f = " ^ c

let string_of_sumtype (v, s, l) =
 "type " ^ "(" ^ (String.concat ", " v) ^ ")" ^ " " ^ s ^ " =" ^
 (String.concat "" 
   (List.map
     (fun (i, tl) -> " | " ^ i ^ " of " ^ 
                     (String.concat " * " tl))
    l))

let print_expr e = print_string (string_of_expr e); print_newline();;

let test f = 
  print_string "*** The function ***\n";
  print_expr f;
  print_string "*** can be divided in gamma = ***\n";
  match do_cut f with (g, a, func) -> print_expr g;
  print_string "*** and alpha = ***\n";
  print_expr a;
  print_string "*** with types ***\n";
  print_string (string_of_functor func);
  print_newline();;

test fv



