/* 
 * Modifications in file: phy.c
 * Author: Ranveer Chandra
 *
 */

void PHY_SSCHSwitchChannel(
			   Node *node, 
			   int sschSeed,
			   int oldPhyChannel,
			   int phyIndex)
{
  int numberChannels = PROP_NumberChannels(node);
  PhyData* thisPhy = node->phyData[phyIndex];
  PhyData802_11 *phy802_11 = (PhyData802_11 *)thisPhy->phyVar;
  int channelIndex, newChannelIndex;
  
  PHY_GetTransmissionChannel(node, phyIndex, &channelIndex);
  PHY_StopListeningToChannel(node, phyIndex, channelIndex);
  thisPhy->channelListening[channelIndex] = FALSE;
  phy802_11->interferencePower_mW = 0;
  
  newChannelIndex = (oldPhyChannel+sschSeed)%(numberChannels);
  PHY_StartListeningToChannel(node, phyIndex, newChannelIndex);
  PHY_SetTransmissionChannel(node, phyIndex, newChannelIndex);
#ifdef DEBUG
  printf("Node %d switched from %d to %d, seed %d interference %f\n", 
	 node->nodeId, channelIndex, newChannelIndex, sschSeed, phy802_11->interferencePower_mW);
#endif
}

void PHY_SSCHSwitchToGivenChannel(
			   Node *node, 
			   int newPhyChannel,
			   int phyIndex)
{
  int numberChannels = PROP_NumberChannels(node);
  PhyData* thisPhy = node->phyData[phyIndex];
  PhyData802_11 *phy802_11 = (PhyData802_11 *)thisPhy->phyVar;
  int channelIndex, newChannelIndex;
  
  PHY_GetTransmissionChannel(node, phyIndex, &channelIndex);
  PHY_StopListeningToChannel(node, phyIndex, channelIndex);
  thisPhy->channelListening[channelIndex] = FALSE;
  phy802_11->interferencePower_mW = 0;

  newChannelIndex = (newPhyChannel)%(numberChannels);
  PHY_StartListeningToChannel(node, phyIndex, newChannelIndex);
  PHY_SetTransmissionChannel(node, phyIndex, newChannelIndex);
#ifdef DEBUG
  printf("Parity: Node %d switched from %d to %d, interference %f\n", 
	 node->nodeId, channelIndex, newChannelIndex, phy802_11->interferencePower_mW);
#endif
}


void PHY_CreateAPhyForMac(
			  .
			  )
{
    
  .............
  .............

  IO_ReadTime(
	      node->nodeId,
	      interfaceAddress,
	      nodeInput,
	      "MAC-802.11-SSCH-SLOT-DURATION",
	      &wasFound,
	      &aClocktypeInput);
  
  if(aClocktypeInput > 0) {
      i = (pc_nrand(node->seed) % numberChannels);
      //i = node->nodeId % (numberChannels-1);
      PHY_StartListeningToChannel(node, phyIndex, i);
  } else {
    ....
  }
  


