/*
 * Author: Ranveer Chandra
 * File  : mac_802_11.h
 * 
 * Add these modifications to mac_802_11.h
 */

#include "ssch.h"


//--------------------------------------------------------------------------
// typedef's enums
//--------------------------------------------------------------------------


// MAC states
typedef enum {
    ..........
    .......

    M802_11_X_SSCH_BEACON             // 17  State when sending ssch beacon

} M802_11_MacStates;


// Type of MAC frame
typedef enum { 
    ..........
    ........

    M802_11_SSCH_BEACON,            // Construct for SSCH frame

    ....
} M802_11MacFrameType;


//--------------------------------------------------------------------------
// typedef's struct
//--------------------------------------------------------------------------


// 802.11 data structure
typedef struct {
  
  //-----------------------------------------------------------------
  // SSCH variables
  clocktype		        sschSlotDuration;         
  clocktype                     sschLastSwitchTime;        
  int				sschSeed[SSCH_NUM_SLOTS];
  int                           sschNextParitySeed;
  int                           sschNextParityChannel;
  int                           sschNextParitySync;
  int                           sschChannel[SSCH_NUM_SLOTS];
  int                           sschNumPacketsReceivedInSlot[SSCH_NUM_SLOTS];
  int                           sschNumDistinctSendersInSlot[SSCH_NUM_SLOTS];
  int                           sschNumPacketsSentSuccessfullyInSlot[SSCH_NUM_SLOTS];
  int                           sschNumPacketsSentInSlot[SSCH_NUM_SLOTS];
  int                           sschCurrentSlot;
  BOOL			        sschDelayedSwitch;
  BOOL			        sschDelayedSwitchTimeout;
  BOOL                          sschBeaconIsDue;
  SSCHRexmtBuffer               sschRexmtBuffer;
  int				sschQueueLength;
  int				sschRetryCountPerSlot;
  int				sschNumChannels;
  int				sschNumSwitches;
  int                           sschNumSlotSwitches;
  clocktype                     sschChannelSwitchTime;
  NodeAddress                   sschSender[MAX_NBRS];
  BOOL                          sschChangeSeedInNextSlot;

  // Maintain the neighbor information
  NodeAddress                   nbrAddress[MAX_NBRS];
  int                           sschNbrSeeds[MAX_NBRS][SSCH_NUM_SLOTS];
  int                           sschNbrChannel[MAX_NBRS][SSCH_NUM_SLOTS];
  clocktype                     sschNbrBeaconTime[MAX_NBRS];
  int                           numNbrs;

  // Addresses of nodes I am currently synched to
  NodeAddress                   sschSyncInfo[SSCH_NUM_SLOTS];

  // Information of buffered packets for each nbr
  int                           numPacketsForAddress[MAX_NBRS];
  // End SSCH definitions
  //-----------------------------------------------------------------
  
  M802_11_TraceType trace;
} MacData802_11;


