/*
 * Author: Ranveer Chandra
 *
 * This file has some changes that have to be made to mac_802_11.c
 * Note that there are more chnages that have to be made as described in 
 * notes.txt or the html documentation
 */ 

void Mac802_11TransmissionHasFinished()
{
  ......
    
  case M802_11_X_SSCH_BEACON:
    M802->sschBeaconIsDue = FALSE;
    //M802->BO = 0;
    Mac802_11SetState(node, M802, M802_11_S_IDLE);
    if(M802->currentMessage == NULL) {
      Mac802_11CheckForOutgoingPacket(node, M802);
    } else {
      M802->dataRateInfo =
	Mac802_11GetDataRateEntry(node, M802, M802->currentNextHopAddress);
      
      Mac802_11SetBackoffIfZero(node, M802);
      Mac802_11AttemptToGoIntoWaitForDifsOrEifsState(node, M802);
    }
    break;

    ...........   
}

void Mac802_11NetworkLayerHasPacketToSend(
    Node* node,
    MacData802_11* M802)
{
  .......  
  if(M802->sschSlotDuration > 0
     && (M802->currentNextHopAddress != ANY_DEST
	 || (SSCH_ENABLE_BCAST_HACK 
	     && M802->currentNextHopAddress == ANY_DEST))) {
    SSCHInsertRexmtBuffer(node, MESSAGE_Duplicate(node, M802->currentMessage), 
			  M802->currentNextHopAddress, &M802->sschRexmtBuffer);
    SSCHIncrementNumPacketsForAddress(M802, M802->currentNextHopAddress, TRUE);
    SSCHMoveAPacketFromRexmtBufferToTheLocalBuffer(node, M802);
  }
  ..........
}

void Mac802_11Layer()
{
  ...........  
  case MSG_MAC_SSCHSwitchChannel: {
    if( Mac802_11PhyStatus(node, M802) == PHY_TRANSMITTING ||
	Mac802_11PhyStatus(node, M802) == PHY_RECEIVING ||
	Mac802_11IsWaitingForResponseState(M802->state) ||
	Mac802_11InTransmittingState(M802) ||
	M802->state == M802_11_S_WFACK || M802->state == M802_11_S_WFCTS || M802->state == M802_11_S_WFDATA ||
	((M802->state == M802_11_S_BO && M802->BO == 0)  || M802->state == M802_11_S_WF_DIFS_OR_EIFS)) {
      
#ifdef DEBUG_EXTRA_LOUD  
      printf("Node %d: Delay switch: Current Mac state %d, phy state %d\n", 
	     node->nodeId, M802->state, Mac802_11PhyStatus(node, M802));
#endif
      // Switch when state is changed
      M802->sschDelayedSwitch = TRUE;
      //if(M802->state == M802_11_S_WF_DIFS_OR_EIFS) {
      //    Mac802_11TransmitFrame(node, M802);
      //}
    } else {
      char delayStr[100];
  #ifdef DEBUG_EXTRA_LOUD  
      ctoa(M802->BO, delayStr);
      printf("Node %d state %d bo %s phy %d\n", 
	     node->nodeId, M802->state, delayStr, Mac802_11PhyStatus(node, M802));
#endif
      MacHandleSSCHSwitchChannel(node, M802);
    }
    break;
  }
  
  case MSG_MAC_SSCHBeacon: {
    MacHandleSSCHBeacon(node, M802);
    break;
  }
  .............
}

void Mac802_11Init(...)
{
  ................

  //--------------------------------------------------------------------
  // Read SSCH-SLOT_TIME.
  // Format is :
  //      MAC-802.11-SSCH-SLOT-DURATION <value>
  // Default is 0 (value 0 implies no channel switching)
  //
  IO_ReadTime(
	      node->nodeId,
	      M802->selfAddr,
	      nodeInput,
	      "MAC-802.11-SSCH-SLOT-DURATION",
	      &wasFound,
	      &aClocktypeInput);
  
  M802->sschDelayedSwitch = FALSE;
  M802->sschDelayedSwitchTimeout = FALSE;
  M802->sschBeaconIsDue = FALSE;
  M802->numNbrs = 0;
  M802->sschChangeSeedInNextSlot = FALSE;

  SSCHInitNbrInfo(M802);
  
  if (wasFound) {
    M802->sschSlotDuration = aClocktypeInput;
    ERROR_Assert(M802->sschSlotDuration >= 0,
		 "Mac802_11Init: "
		 "Value of MAC-802.11-SSCH-SLOT-DURATION is negative.\n");
    
    if (aClocktypeInput > 0) {
      //int sschSeeds[] = {SSCH_SEED_0, SSCH_SEED_1, SSCH_SEED_2, SSCH_SEED_3};
      int countSlot = 0;
      M802->sschCurrentSlot = 0;
      M802->sschNumSlotSwitches = 1;

      M802->sschNumSwitches = 1;
      IO_ReadInt(
		 node->nodeId,
		 M802->selfAddr,
		 nodeInput,
		 "MAC-802.11-SSCH-NUM-CHANNELS",
		 &wasFound,
		 &anIntInput);
      
      if (wasFound) {
	M802->sschNumChannels = anIntInput;
	ERROR_Assert(M802->sschNumChannels >= 0,
		     "Mac802_11Init: "
		     "Value of MAC-802.11-SSCH-NUM-CHANNELs is negative.\n");
      }
      else {
	M802->sschNumChannels = SSCH_NUM_CHANNELS;
      }
      //M802->sschSeed = sschSeeds[pc_nrand(node->seed) % SSCH_NUM_SEEDS];
      for(countSlot=0; countSlot < SSCH_NUM_SLOTS; countSlot++) {
	M802->sschSeed[countSlot] = (pc_nrand(node->seed) % SSCH_NUM_SEEDS) + 1;
	if(countSlot == 0)
	  PHY_GetTransmissionChannel(node, M802->myMacData->phyNumber, &M802->sschChannel[countSlot]);
	else
	  M802->sschChannel[countSlot] = (pc_nrand(node->seed) % M802->sschNumChannels);
	
	M802->sschNumPacketsReceivedInSlot[countSlot] = 0;
	M802->sschNumPacketsSentInSlot[countSlot] = 0;
	M802->sschNumDistinctSendersInSlot[countSlot] = 0;
	M802->sschNumPacketsSentSuccessfullyInSlot[countSlot] = 0;
	M802->sschSyncInfo[countSlot] = ANY_DEST;

	//M802->sschSeed[countSlot] = (node->nodeId) % SSCH_NUM_SEEDS + 1;
      }

      M802->sschNextParitySeed = M802->sschSeed[SSCH_PARITY_SLOT];
      M802->sschNextParityChannel = M802->sschChannel[SSCH_PARITY_SLOT];
      M802->sschNextParitySync = ANY_DEST;

      Mac802_11StartTimerOfGivenType(node, M802, M802->sschSlotDuration, MSG_MAC_SSCHSwitchChannel);
      Mac802_11StartTimerOfGivenType(node, M802, M802->sschSlotDuration/2, MSG_MAC_SSCHBeacon);
      IO_ReadInt(
		 node->nodeId,
		 M802->selfAddr,
		 nodeInput,
		 "MAC-802.11-SSCH-QUEUE-LENGTH",
		 &wasFound,
		 &anIntInput);
      
      if (wasFound) {
	M802->sschQueueLength = anIntInput;
	ERROR_Assert(M802->sschQueueLength >= 0,
		     "Mac802_11Init: "
		     "Value of MAC-802.11-SSCH-QUEUE-LENGTH is negative.\n");
      }
      else {
	M802->sschQueueLength = SSCH_REXMT_BUFFER_SIZE;
      }
      SSCHInitRexmtBuffer(&M802->sschRexmtBuffer);
      IO_ReadInt(
		 node->nodeId,
		 M802->selfAddr,
		 nodeInput,
		 "MAC-802.11-SSCH-RETRY-COUNT-PER-SLOT",
		 &wasFound,
		 &anIntInput);
      
      if (wasFound) {
	M802->sschRetryCountPerSlot = anIntInput;
	ERROR_Assert(M802->sschRetryCountPerSlot >= 0,
		     "Mac802_11Init: "
		     "Value of MAC-802.11-SSCH-RETRY-COUNT-PER-SLOT is negative.\n");
      }
      else {
	M802->sschRetryCountPerSlot = SSCH_RETRY_COUNT_PER_SLOT;
      }

      IO_ReadTime(
		  node->nodeId,
		  M802->selfAddr,
		  nodeInput,
		  "MAC-802.11-SSCH-CHANNEL-SWITCH-TIME",
		  &wasFound,
		  &aClocktypeInput);
  
      if (wasFound) {
	M802->sschChannelSwitchTime = aClocktypeInput;
	ERROR_Assert(M802->sschChannelSwitchTime >= 0,
		     "Mac802_11Init: "
		     "Value of MAC-802.11-SSCH-CHANNEL-SWITCH-TIME is negative.\n");
      }
      else {
	M802->sschChannelSwitchTime = SSCH_CHANNEL_SWITCH_TIME;
      }
    }
  }
  else {
    M802->sschSlotDuration = 0;
  }
  // End SSCH modifications
  //--------------------------------------------------------------------
  
  .................
  
}




