/*
 * Author: Ranveer Chandra
 * File: SSCH.h
 */

#include "api.h"

//-------------------------------------------------------------------------- 
// SSCH Queue definitions and declarations
//-------------------------------------------------------------------------- 

// SSCH Random Seeds
#define SSCH_NUM_SEEDS					12
#define SSCH_SEED_0				       	2
#define SSCH_SEED_1			      		6
#define SSCH_SEED_2		       			7
#define SSCH_SEED_3	       				11

#define SSCH_NUM_CHANNELS			       	13
#define SSCH_CHANNEL_SWITCH_TIME       		       	(80 * MICRO_SECOND)
#define SSCH_REXMT_BUFFER_SIZE				50000
#define SSCH_RETRY_COUNT_PER_SLOT			3
#define SSCH_BUFFER_THRESH_PER_NBR                      50
#define SSCH_SYNC_THRESH                                6

#define SSCH_NUM_SLOTS                                  4
#define SSCH_PARITY_SLOT                                2
#define MAX_NBRS                                        100

// SSCH message retransmit buffer entry. Buffer to temporarily store messages
// After sending the message out to destination, until an acknowledgement
// comes for the message.

typedef struct str_ssch_rexmt_buffer_entry
{
  NodeAddress nextHop;  // next hop to which the message has been sent
  unsigned int perSlotRetryCount;   // number of times retransmitted within this slot
  unsigned int acrossSlotRetryCount; // number of slots in which retransmitted
  unsigned short msgId;
  clocktype timeStamp;  // when the message has been inserted
  Message* msg;         // sent message
  struct str_ssch_rexmt_buffer_entry* next;
} SSCHRexmtBufferEntry;

// SSCH message buffer
typedef struct
{
  SSCHRexmtBufferEntry* head; // pointer to the first entry
  int sizeInPacket;          // number of packets in the retransmit buffer
} SSCHRexmtBuffer;

//
// SSCH Beacon frame.
// Note: - All frames types must match the short control (this one)
//         exactly for its first four (universal) fields.
//       - FCS is supposed to be after data payload.  However,
//         we include FCS within the header for coding convenience.
//       - Actual frame size need not match standard here since
//         we use M802_11_SHORT_CTRL_FRAME_SIZE to determine size.

typedef struct {
                              //  Should Be  Actually
  unsigned char frameType;    //      -         -
  unsigned char frameFlags;   //      2         2
  char Padding[2];            //      -         2
  char sschSeeds[4];          //      4         4
  int offset;                 //      4         4
} M802_11SSCHBeaconFrame;     //---------------------
                              //     10        12

void SSCHInitRexmtBuffer(SSCHRexmtBuffer *rexmtBuffer);

void SSCHInsertRexmtBuffer(
			   Node* node,
			   Message* msg,
			   NodeAddress nextHop,
			   SSCHRexmtBuffer* rexmtBuffer);

/*
void SSCHDeleteRexmtBufferByNextHop(
				    Node* node,
				    SSCHRexmtBuffer* rexmtBuffer,
				    NodeAddress nextHop);
*/
 
void SSCHDeleteRexmtBufferByEntry(
				  Node* node,
				  SSCHRexmtBuffer* rexmtBuffer,
				  SSCHRexmtBufferEntry* rexmtBufEntry);

SSCHRexmtBufferEntry* SSCHSearchRexmtBuffer(
					    SSCHRexmtBuffer* rexmtBuffer,
					    NodeAddress nextHop);









