#include <stdio.h>
#include "read.h"
#include "read_private.h"
#include "queue.h"
#include "minithread.h"
#include "synch.h"
#include "interrupts.h"

#define READ_INTERRUPT_TYPE 3

queue_t buffers;
semaphore_t new_data;

int WINAPI read_poll(void* arg) {
	char* buffer;

	while (1) {
		buffer = (char*) malloc(MAX_LINE_LENGTH*sizeof(char));	
		gets(buffer);

#ifdef WINCE
		if(buffer[0] != 0) 
		    send_interrupt(READ_INTERRUPT_TYPE, buffer);
#else
		send_interrupt(READ_INTERRUPT_TYPE, buffer);
#endif
	}
}

void read_handler(void* arg) {	
	set_interrupt_level(DISABLED);
	queue_append(buffers, arg);
	set_interrupt_level(ENABLED);
	semaphore_V(new_data);
}

int miniterm_initialize() {
  HANDLE read_thread = NULL;
  DWORD id;

  kprintf("Starting read interrupts.\n");
  register_interrupt(READ_INTERRUPT_TYPE, read_handler, INTERRUPT_DEFER);

  buffers = queue_new();
  new_data = semaphore_create();
  semaphore_initialize(new_data, 0);

  read_thread = CreateThread(NULL, 0, read_poll, NULL, 0, &id); 
  assert(read_thread != NULL); 
  
  return 0;
}

int miniterm_read(char* buffer, int len) {
	char* extract_buffer;

	semaphore_P(new_data);
	set_interrupt_level(DISABLED);
	queue_dequeue(buffers, &extract_buffer);
	set_interrupt_level(ENABLED);

	strncpy(buffer, extract_buffer, len-1);
	free(extract_buffer);

	return strlen(buffer);
}



