/*
 *	Implementation of minisockets.
 */
#include "minisocket.h"

struct minisocket {
  int dummy; /* delete this field */
  /* put your definition of minisockets here */
};

/* 
 * Put the initialization code in minimsg_initialize.
 * You might have to slightly modify your miniports
 * to accomodate minisockets (that you hopefully build 
 * on top of miniports).
 */

/* 
 * Listen for a connection from somebody else. When communication link is created
 * return a minisocket_t through which the communication can be made from now on.
 *
 * The argument "port" is the port number on the local machine on which the communication
 * is made. 
 *
 * Return value: the minisocket_t created, otherwise sets it to NULL and returns the errocode
 * in the "error" variable.
 */
minisocket_t minisocket_server_create(int port, minisocket_error *error){
}


/*
 * Initiate the communication with a remote site. When communication is established create a
 * minisocket through which the communication can be made from now on.
 *
 * The first argument is the network address of the remote machine. 
 *
 * The argument "port" is the port number on the remote machine to which the connection 
 * is made. The port number of the local machine is one of the free port numbers.
 *
 * Return value: the minisocket_t created, otherwise sets it to NULL and returns the errocode
 * in the "error" variable.
 */

minisocket_t minisocket_client_create(network_address_t addr, int port, minisocket_error *error){
}


/* 
 * Send a message to the other end of the socket. The message on the other end should 
 * be a prefix of the message transmitted (possibly all of it).
 * minisocket_send should block until the whole message is reliably transmitted 
 * or an error/timeout occurs
 *
 * Arguments: the socket on which the communication is made (socket), the message
 *            to be transmitted (msg) and its length (len).
 * Return value: returns the number of successfully transmitted bytes. Sets the error
 *            code and returns -1 if an error is encountered.
 */
int minisocket_send(minisocket_t socket, minimsg_t msg, int len, minisocket_error *error){
}


/*
 * Receive a message from the other end of the socket. Blocks until max_len bytes or a full 
 * message is received (that can be smaller than max_len bytes).
 *
 * Arguments: the socket on which the communication is made (socket), the memory location
 *            where the received message is returned (msg) and its maximum length (max_len).
 * Return value: -1 in case of error and sets the error code, the number of bytes received otherwise
 */
int minisocket_receive(minisocket_t socket, minimsg_t msg, int max_len, minisocket_error *error){
}

/* Close a connection. If minisocket_close is issued, any send or receive should fail.
 * As soon as the other side knows about the close, it should fail any send or receive 
 * in progress. The minisocket is destroyed by minisocket_close function.
 * The function should never fail.
 */
void minisocket_close(minisocket_t socket){
}
