#ifndef __MINIMSG_H__
#define __MINIMSG_H__
/*
 *	Definitions for minimsgs and miniports.
 *
 *      You should implement the functions defined in this file, using
 *      the names for types and functions defined here. Functions must take
 *      the exact arguments in the prototypes.
 */

typedef struct miniport* miniport_t;
typedef char* minimsg_t;

#include "network.h"
#include "minisocket.h"



/* 
 *   somewhat arbitrary, but must be <= MAX_NETWORK_PKT_SIZE - (your header size)
 */   
#define MINIMSG_MAX_MSG_SIZE (4096)


extern void minimsg_initialize();

extern miniport_t miniport_local_create();
extern miniport_t miniport_remote_create(network_address_t addr, int id);

extern void miniport_destroy(miniport_t miniport);

extern int minimsg_send(miniport_t local, miniport_t remote, 
				minimsg_t msg, int len);

extern int minimsg_receive(miniport_t local, miniport_t* remote, 
			   	   minimsg_t msg, int *len);

#endif __MINIMSG_H__
