/* 
 *    conn-network test program 4
 *
 *    usage: conn-network4 
 *    spawns 11 threads, 1 for server.
 *    The other 10 threads send packets to the server via the same socket.
 *    The goal of this file is to test the mutual exclusion of send() subroutine
*/

#include "minithread.h"
#include "minisocket.h"
#include "synch.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define BUFFER_SIZE 1280

int port = 80; /* port on which we do the communication */
semaphore_t wait_sem;
char send_buffer[BUFFER_SIZE];
minisocket_t send_socket;	/* shared by all the sending threads */

int client(int* arg); /* forward declaration */

int server(int* arg) {
  char buffer[BUFFER_SIZE];
  int i;
  int bytes_received;
  int received_bytes;
  minisocket_t socket;
  minisocket_error error;
  minithread_t sender;
  
  sender = minithread_fork(client, NULL);
  socket = minisocket_server_create(port,&error);
  if (socket==NULL){
    printf("Receicved error code: %d. \n",error);
	semaphore_V(wait_sem);
    return 0;
  }
  bytes_received=0;
  while (bytes_received!=BUFFER_SIZE){
    received_bytes=BUFFER_SIZE - bytes_received;
	received_bytes = minisocket_receive(socket,buffer+bytes_received,received_bytes, &error);
    if (received_bytes==-1){
      printf("*****GRADING: Receiving error. Code: %d. \n",error);
    }   
    /* test the information received */
    for (i=0; i<received_bytes; i++){
		if (buffer[bytes_received+i]!=((bytes_received+i)%128)){
		   printf("*****GRADING: The %d'th byte received is wrong.\n", bytes_received+i);
      }
    }
    bytes_received+=received_bytes;
  }

  printf("*****GRADING: All bytes received.\n");
  
  semaphore_V(wait_sem);
  
  /* close the connection */
  minisocket_close(socket);

  return 0;
}
	/* each send_thread sends BUFFER_SIZE/10 data to the server */
int send_thread(int* arg) {
  int id;
  int error;
  int bytes_sent=0;
  int size = BUFFER_SIZE/10;

  id = *arg;
	/* send the message */
  while (bytes_sent != size){
	int trans_bytes;
	printf("*****GRADING: thread %d is sending packets.\n", id);
    trans_bytes=
		  minisocket_send(send_socket,send_buffer + size*id + bytes_sent,
						      size - bytes_sent, &error);  
    if (trans_bytes==-1){
      printf("Sending error. Code: %d. Aborting.\n",error);
      return 0;
    }  
	printf("*****GRADING: %d bytes data are sent by thread %d \n", trans_bytes,id);
    bytes_sent+=trans_bytes;
  }
  return 0;
}

int client(int* arg) {
  int i;
  int thread_id[10];
  network_address_t my_address;
  minisocket_error error;
  
  network_get_my_address(my_address);
  
  /* create a network connection to the local machine */
  send_socket = minisocket_client_create(my_address, port,&error);
  if (send_socket==NULL){
    printf("Receicved error code: %d.\n",error);
    return 0;
  }
  /* Fill in the buffer with numbers from 0 to BUFFER_SIZE-1 */
  for (i=0; i<BUFFER_SIZE; i++){
    send_buffer[i]=i%128;
  }
  for (i=0; i<10; i++) {
	  thread_id[i]=i;
	  minithread_fork(send_thread, &thread_id[i]);
  }
  semaphore_P(wait_sem);
  minisocket_close(send_socket);
  return 0;
}

main(int argc, char** argv) {
  wait_sem = semaphore_create();
  semaphore_initialize(wait_sem,0);
  minithread_system_initialize(server, NULL);
}
