/*
 * Multilevel queue manipulation functions  
 */
#ifndef __MULTILEVEL_QUEUE_H__
#define __MULTILEVEL_QUEUE_H__

#include "queue.h"

/*
 * multilevel_queue_t is a pointer to an internally maintained data structure.
 * Clients of this package do not need to know how the queues are
 * represented. They see and manipulate only multilevel_queue_t's. 
 */
typedef void* multilevel_queue_t;

/*
 * Return an empty queue. On error should return NULL.
 */
extern multilevel_queue_t multilevel_queue_new(int number_of_levels);

/*
 * Appends an any_t to the queue at the specified level.  Return
 * 0 (success) or -1 (failure).
 */
extern int multilevel_queue_enqueue(multilevel_queue_t queue, int level, any_t item);

/*
 * Dequeue and return the first any_t from the queue starting at the specified level. 
 * Levels wrap around so as long as there is something in the queue an item should be returned.
 * Return level and first item if queue is nonempty, or -1 (failure) and
 * NULL if queue is empty.
 */
extern int multilevel_queue_dequeue(multilevel_queue_t queue, int level, any_t *item);

/* 
 * Free the queue and return 0 (success) or -1 (failure).
 */
extern int multilevel_queue_free(multilevel_queue_t queue);

#endif __MULTILEVEL_QUEUE_H__
