/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.util.adt;

import COM.xerox.digipaper.util.CanCompareData;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import COM.xerox.digipaper.util.GenericDataComparator;
import COM.xerox.digipaper.util.adt.FifoBase;
import COM.xerox.digipaper.util.adt.FifoElement;

public class CircularQueue
extends FifoBase {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(false);
    protected static Exception _exception = new Exception();
    CanCompareData comp;

    public CircularQueue() {
        this(new GenericDataComparator());
    }

    public CircularQueue(CanCompareData canCompareData) {
        this.comp = canCompareData;
    }

    public int compare(Object object, Object object2) {
        return this.comp.compare(object, object2);
    }

    public synchronized FifoElement addObjectBeforeCurrent(Object object) {
        return super.addObjectBeforeCurrent(object);
    }

    public synchronized Object removeObjectAtCurrent() {
        return super.removeObjectAtCurrent();
    }

    public synchronized void advanceCurrent() {
        if (this.cur != null) {
            this.cur = this.cur.getNext();
        }
    }

    public synchronized void backupCurrent() {
        super.backupCurrent();
    }

    public synchronized FifoElement getCurrent() {
        return this.cur;
    }

    public synchronized Object getObjectAtCurrent() {
        if (this.cur == null) {
            return null;
        }
        return this.cur.getData();
    }

    public synchronized boolean isEmpty() {
        dbg.dprint("CircularQueue::isEmpty() starts");
        boolean bl = super.isEmpty();
        dbg.dprint("CircularQueue::isEmpty() ends");
        return bl;
    }

    public synchronized boolean removeFifoElement(FifoElement fifoElement) {
        FifoElement fifoElement2 = this.getCurrent();
        if (fifoElement2 == null) {
            return false;
        }
        if (fifoElement.getNext() == null) {
            return false;
        }
        this.setCurrent(fifoElement);
        this.removeObjectAtCurrent();
        if (fifoElement != fifoElement2) {
            this.setCurrent(fifoElement2);
        }
        return true;
    }

    public synchronized FifoElement getElementWithData(Object object) {
        FifoElement fifoElement = this.getCurrent();
        dbg.dprint("CircularQueue::getElementWithData() starts");
        try {
            FifoElement fifoElement2 = fifoElement;
            FifoElement fifoElement3 = null;
            while (fifoElement3 != fifoElement2) {
                fifoElement3 = this.getCurrent();
                if (this.comp.compare(fifoElement3.getData(), object) == 0) {
                    throw _exception;
                }
                dbg.dprint("CircularQueue::getElementWithData() looping");
                this.advanceCurrent();
                fifoElement3 = this.getCurrent();
            }
        }
        catch (Exception exception) {
            this.setCurrent(fifoElement);
            dbg.dprint("CircularQueue::getElementWithData() ends");
            return this.getCurrent();
        }
        dbg.dprint("CircularQueue::getElementWithData() ends");
        this.setCurrent(fifoElement);
        return null;
    }

    public synchronized CircularQueue getAllMatching(Object object) {
        FifoElement fifoElement;
        CircularQueue circularQueue = new CircularQueue(this.comp);
        FifoElement fifoElement2 = fifoElement = this.getCurrent();
        FifoElement fifoElement3 = null;
        while (fifoElement2 != fifoElement3) {
            fifoElement3 = this.getCurrent();
            Object object2 = fifoElement3.getData();
            if (this.comp.compare(object2, object) == 0) {
                circularQueue.addObjectBeforeCurrent(object2);
            }
            this.advanceCurrent();
            fifoElement3 = this.getCurrent();
        }
        this.setCurrent(fifoElement);
        return circularQueue;
    }

    public synchronized int getNumElements() {
        return super.getNumElements();
    }
}

