/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.thumbnails;

import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.thumbnails.TInteger;
import COM.xerox.digipaper.applet.xiff.thumbnails.Thumbnail;
import COM.xerox.digipaper.util.CanBeNotified;
import COM.xerox.digipaper.util.CanGetObjects;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class ThumbnailGetterTop
implements CanGetObjects,
CanBeNotified {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected CanBeNotified _recipient;
    protected CanGetObjects thumbnail_getter;
    protected Component c;
    protected Thumbnail cur_thumb;
    protected XIFFFile xiff_file;
    protected Hashtable outstanding_requests;
    protected boolean getting_a_page;
    protected Image error_image;
    protected Image dummy_image;

    public ThumbnailGetterTop(CanGetObjects canGetObjects, XIFFFile xIFFFile, Component component) {
        this.thumbnail_getter = canGetObjects;
        this.xiff_file = xIFFFile;
        this.outstanding_requests = new Hashtable();
        this.error_image = null;
        this.dummy_image = null;
        this.c = component;
        this.cur_thumb = null;
        this._recipient = null;
        this.getting_a_page = false;
    }

    public synchronized void stopGettingObject(CanBeNotified canBeNotified, Object object) {
        dbg.dprint("Stopping getting the thumbnail for page " + (Integer)object + ".", DebugInfoPrinter.DBUG_THUMBNAILS);
        TInteger tInteger = new TInteger((Integer)object);
        Thumbnail thumbnail = (Thumbnail)this.outstanding_requests.remove(tInteger);
        if (thumbnail == null && this.getting_a_page) {
            this.thumbnail_getter.stopGettingObject(this, this.cur_thumb);
            this.getting_a_page = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean startGettingObject(CanBeNotified canBeNotified, Object object) {
        Graphics graphics;
        dbg.dprint("ThumbnailGetterTop::startGettingObject() starts", DebugInfoPrinter.DBUG_THUMBNAILS);
        TInteger tInteger = new TInteger((Integer)object);
        if (tInteger.intValue() < 0) return false;
        if (tInteger.intValue() >= this.xiff_file.getNumPages()) {
            return false;
        }
        if (this.dummy_image == null) {
            this.dummy_image = this.c.createImage(70, 70);
            graphics = this.dummy_image.getGraphics();
            graphics.drawString("getting", 15, 20);
        }
        if (this.error_image == null) {
            this.error_image = this.c.createImage(70, 70);
            graphics = this.error_image.getGraphics();
            graphics.drawString("error", 15, 20);
        }
        Thumbnail thumbnail = new Thumbnail(this.dummy_image, this.c, tInteger.intValue());
        Hashtable hashtable = this.outstanding_requests;
        synchronized (hashtable) {
            if (this._recipient != null && this._recipient != canBeNotified) {
                return false;
            }
            this._recipient = canBeNotified;
            if (this.getting_a_page) {
                this.outstanding_requests.put(tInteger, thumbnail);
            } else {
                this.getting_a_page = true;
                this.cur_thumb = thumbnail;
                if (!this.thumbnail_getter.startGettingObject(this, thumbnail)) {
                    dbg.dprint("Error getting thumbnail.", DebugInfoPrinter.DBUG_ERROR);
                    return false;
                }
            }
        }
        canBeNotified.Update(true, tInteger, thumbnail);
        dbg.dprint("ThumbnailGetterTop::startGettingObject() ends", DebugInfoPrinter.DBUG_THUMBNAILS);
        return true;
    }

    public void Update(boolean bl, Object object, Object object2) {
        Serializable serializable;
        dbg.dprint("ThumbnailGetterTop::Update() starts", DebugInfoPrinter.DBUG_THUMBNAILS);
        if (object != object2) {
            serializable = (Thumbnail)object;
            Thumbnail thumbnail = (Thumbnail)object2;
            ((Thumbnail)serializable).setImage(thumbnail.getImage());
        }
        serializable = this.outstanding_requests;
        synchronized (serializable) {
            this.getting_a_page = false;
            this.cur_thumb = null;
            if (this.outstanding_requests.isEmpty()) {
                this._recipient = null;
            } else {
                Enumeration enumeration = this.outstanding_requests.keys();
                TInteger tInteger = (TInteger)enumeration.nextElement();
                Thumbnail thumbnail = (Thumbnail)this.outstanding_requests.remove(tInteger);
                this.getting_a_page = true;
                this.cur_thumb = thumbnail;
                if (!this.thumbnail_getter.startGettingObject(this, thumbnail)) {
                    dbg.dprint("Error getting image from which to generate thumbnail.", DebugInfoPrinter.DBUG_ERROR);
                    thumbnail.setImage(this.error_image);
                }
            }
        }
        dbg.dprint("ThumbnailGetterTop::Update() ends", DebugInfoPrinter.DBUG_THUMBNAILS);
    }
}

