/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.ifd_info.tc;

import COM.xerox.digipaper.applet.WJRim.PackedImage;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.Bitfile;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.Decoder;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.io.IOException;

public class TokenDictionary {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    XIFFFile xiff_file;
    public byte[][] jpeg_buffers;
    public PackedImage[] toks;
    public PackedImage[] toks_bp2;
    int[] uses;
    static final byte[] useDecoder0nbits;
    static final byte[] useDecoder0outstate;
    static final short[] useDecoder0offset;
    static final byte[] useDecoder1nbits;
    static final byte[] useDecoder1outstate;
    static final short[] useDecoder1offset;
    static final byte[] whDecodernbits;
    static final byte[] whDecoderoutstate;
    static final short[] whDecoderoffset;
    static Decoder whDecoder;
    static Decoder[] useDecoders;
    static final int JPEG_EXT_TAG = 1;
    static final int SCALEDTOK_EXT_TAG = 2;

    TokenDictionary(byte[] byArray, int n, int n2, XIFFFile xIFFFile) throws IOException {
        this.xiff_file = xIFFFile;
        if (byArray[n] != 0) {
            throw new IOException("Bad dictblock version: " + byArray[n]);
        }
        int n3 = xIFFFile.GetLong(byArray, n + 1);
        this.toks = this.DecodeTokenDictionary(byArray, n + 5, true);
        int n4 = n2 - n3 - 5;
        int n5 = 5 + n3 + n;
        while (n4 > 0) {
            int n6 = xIFFFile.GetShort(byArray, n5);
            int n7 = xIFFFile.GetLong(byArray, n5 + 2);
            switch (n6) {
                case 1: {
                    dbg.dprint("JPEG extension tag", DebugInfoPrinter.DBUG_XIFF_EXT);
                    this.readJPEGExtension(byArray, n5 + 6);
                    break;
                }
                case 2: {
                    dbg.dprint("Scaled TokenDictionary extension tag", DebugInfoPrinter.DBUG_XIFF_EXT);
                    this.toks_bp2 = this.DecodeTokenDictionary(byArray, n5 + 6, false);
                    break;
                }
                default: {
                    dbg.dprint("Unknown Dictionary Block extension tag: " + n6, DebugInfoPrinter.DBUG_ERROR);
                }
            }
            n4 -= n7 + 6;
            n5 += n7 + 6;
        }
    }

    void readJPEGExtension(byte[] byArray, int n) {
        int n2 = this.xiff_file.GetLong(byArray, n);
        dbg.dprint("Dictionary jpeg extension block with " + n2 + " jpegs", DebugInfoPrinter.DBUG_XIFF_EXT);
        byte by = byArray[n + 4];
        int n3 = Math.abs(by);
        dbg.dprint("Bits per offset: " + n3, DebugInfoPrinter.DBUG_XIFF_EXT_VERBOSE);
        boolean bl = by < 0;
        dbg.dprint("Images are RGB: " + bl, DebugInfoPrinter.DBUG_XIFF_EXT_VERBOSE);
        Bitfile bitfile = new Bitfile(byArray, n + 5);
        this.jpeg_buffers = new byte[n2][];
        int n4 = 6 + n3 * n2 / 8;
        int n5 = bitfile.readCode(n3) - n4;
        this.jpeg_buffers[0] = new byte[n5];
        System.arraycopy(byArray, n4 += n, this.jpeg_buffers[0], 0, n5);
        int n6 = 1;
        while (n6 < n2) {
            n5 = bitfile.readCode(n3);
            this.jpeg_buffers[n6] = new byte[n5];
            System.arraycopy(byArray, n4 += n5, this.jpeg_buffers[n6], 0, n5);
            ++n6;
        }
    }

    PackedImage[] DecodeTokenDictionary(byte[] byArray, int n, boolean bl) throws IOException {
        int n2;
        Bitfile bitfile = new Bitfile(byArray, n);
        int n3 = bitfile.readValue();
        int n4 = bitfile.readCode(1);
        Decoder decoder = useDecoders[n4];
        if (bl) {
            this.uses = new int[n3];
        }
        PackedImage[] packedImageArray = new PackedImage[n3];
        int n5 = 0;
        int n6 = 0;
        while ((n2 = whDecoder.readEncoded(bitfile)) != 100000) {
            int n7 = n6;
            n5 += n2 + 1;
            int n8 = 0;
            int n9 = 0;
            while ((n2 = whDecoder.readEncoded(bitfile)) != 100000) {
                n9 += (n8 += n2);
                n2 = decoder.readEncoded(bitfile);
                packedImageArray[n6] = new PackedImage(n8, n5);
                if (bl) {
                    this.uses[n6] = n2;
                }
                ++n6;
            }
            int n10 = bitfile.readValue();
            bitfile.flush();
            int n11 = (n9 + 7) / 8;
            PackedImage packedImage = new PackedImage(byArray, bitfile.getOffset(), n9, n5, n10);
            if (n10 == 0) {
                n10 = n11 * n5;
            }
            bitfile.setOffset(bitfile.getOffset() + n10);
            if (n6 == n7 + 1) {
                packedImageArray[n7] = packedImage;
                continue;
            }
            int n12 = 0;
            int n13 = n7;
            while (n13 < n6) {
                packedImage.clipInto(packedImageArray[n13], n12);
                n12 += packedImageArray[n13].width;
                ++n13;
            }
        }
        return packedImageArray;
    }

    static {
        byte[] byArray = new byte[7];
        byArray[0] = 1;
        byArray[2] = 2;
        byArray[5] = 5;
        byArray[6] = -1;
        useDecoder0nbits = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = 1;
        byArray2[2] = 3;
        useDecoder0outstate = byArray2;
        short[] sArray = new short[7];
        sArray[1] = 1;
        sArray[4] = 2;
        sArray[5] = 3;
        sArray[6] = 35;
        useDecoder0offset = sArray;
        byte[] byArray3 = new byte[15];
        byArray3[0] = 1;
        byArray3[2] = 2;
        byArray3[4] = 1;
        byArray3[5] = 1;
        byArray3[6] = 1;
        byArray3[8] = 1;
        byArray3[9] = 2;
        byArray3[10] = 4;
        byArray3[11] = 6;
        byArray3[12] = 1;
        byArray3[13] = 2;
        byArray3[14] = -1;
        useDecoder1nbits = byArray3;
        byte[] byArray4 = new byte[15];
        byArray4[0] = 1;
        byArray4[2] = 3;
        byArray4[4] = 7;
        byArray4[5] = 9;
        byArray4[6] = 11;
        byArray4[12] = 13;
        useDecoder1outstate = byArray4;
        short[] sArray2 = new short[15];
        sArray2[1] = 2;
        sArray2[3] = 3;
        sArray2[7] = 4;
        sArray2[8] = 5;
        sArray2[9] = 7;
        sArray2[10] = 15;
        sArray2[11] = 31;
        sArray2[13] = 11;
        sArray2[14] = 95;
        useDecoder1offset = sArray2;
        byte[] byArray5 = new byte[17];
        byArray5[0] = 1;
        byArray5[2] = 1;
        byArray5[4] = 1;
        byArray5[6] = 1;
        byArray5[7] = 3;
        byArray5[8] = -1;
        byArray5[16] = -1;
        whDecodernbits = byArray5;
        byte[] byArray6 = new byte[17];
        byArray6[0] = 1;
        byArray6[2] = 3;
        byArray6[4] = 5;
        byArray6[6] = 7;
        byArray6[7] = 9;
        whDecoderoutstate = byArray6;
        short[] sArray3 = new short[17];
        sArray3[3] = 1;
        sArray3[5] = 2;
        sArray3[8] = 10;
        sArray3[9] = 3;
        sArray3[10] = 4;
        sArray3[11] = 5;
        sArray3[12] = 6;
        sArray3[13] = 7;
        sArray3[14] = 8;
        sArray3[15] = 9;
        whDecoderoffset = sArray3;
        whDecoder = new Decoder(whDecodernbits, whDecoderoutstate, whDecoderoffset);
        useDecoders = new Decoder[]{new Decoder(useDecoder0nbits, useDecoder0outstate, useDecoder0offset), new Decoder(useDecoder1nbits, useDecoder1outstate, useDecoder1offset)};
    }
}

