/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.ifd_info.tc;

import COM.xerox.digipaper.applet.xiff.DelayedBuffer;
import COM.xerox.digipaper.applet.xiff.DictionaryEntry;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.TokenDictionary;
import COM.xerox.digipaper.util.BinarySemaphore;
import COM.xerox.digipaper.util.DebugInfoPrinter;

public class GetDictionaryThread
extends Thread {
    TokenDictionary token_dictionary;
    XIFFFile xiff_file;
    DictionaryEntry entry;
    public BinarySemaphore sem;
    protected static int thread_id;
    protected static DebugInfoPrinter dbg;

    static synchronized int getNextThreadId() {
        return thread_id++;
    }

    GetDictionaryThread(DictionaryEntry dictionaryEntry, XIFFFile xIFFFile) {
        super("GetDictionaryThread #" + GetDictionaryThread.getNextThreadId());
        this.entry = dictionaryEntry;
        this.xiff_file = xIFFFile;
        this.sem = new BinarySemaphore();
    }

    public void run() {
        dbg.dprint("GetDictionaryThread starts", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
        try {
            dbg.dprint("GetDictionaryThread about to read range from XIFF file.", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
            DelayedBuffer delayedBuffer = this.xiff_file.RAFile.ReadRange(this.entry.offset, this.entry.size);
            dbg.dprint("GetDictionaryThread about to get data from delayed buffer.", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
            byte[] byArray = delayedBuffer.GetData();
            dbg.dprint("GetDictionaryThread about to create new token dictionary.", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
            this.token_dictionary = this.entry.dictionary = new TokenDictionary(byArray, 0, this.entry.size, this.xiff_file);
            dbg.dprint("GetDictionaryThread about to create new token dictionary.", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
        }
        catch (Exception exception) {
            dbg.dprint("GetDictionaryThread: exception getting dictionary", DebugInfoPrinter.ERROR);
            exception.printStackTrace();
        }
        this.sem.V();
        dbg.dprint("GetDictionaryThread ends.", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
    }

    static {
        dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    }
}

