/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.ifd_info;

import COM.xerox.digipaper.applet.WJRim.PackedImage;
import COM.xerox.digipaper.applet.xiff.IFD;
import COM.xerox.digipaper.applet.xiff.IFDInfo;
import COM.xerox.digipaper.applet.xiff.ifd_info.ImageDecoder;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Vector;

public class IFDInfoJPEG
extends IFDInfo {
    protected static float DEFAULT_RES_OF_MASTER_IMAGE = 300.0f;
    protected URL url;
    protected Vector buffers;

    public IFDInfoJPEG(IFD iFD, Vector vector, URL uRL) {
        super(iFD);
        this.buffers = vector;
        this.url = uRL;
    }

    protected Image getImageFromBuffer(byte[] byArray, Component component) {
        Image image;
        try {
            ImageProducer imageProducer = new ImageDecoder(byArray, 0, byArray.length, "image/jpeg", this.url).getProducer();
            image = component.createImage(imageProducer);
        }
        catch (Exception exception) {
            IFDInfo.dbg.dprint("IFDInfo::getImageFromBuffer() exception decoding and drawing jpeg from subIFD.", DebugInfoPrinter.DBUG_ERROR);
            image = null;
            exception.printStackTrace();
        }
        return image;
    }

    public boolean mustCreateImage() {
        return this.buffers.size() == 1;
    }

    public Image createImage(Component component) {
        byte[] byArray = (byte[])this.buffers.elementAt(0);
        return this.getImageFromBuffer(byArray, component);
    }

    public boolean mayBeMasked() {
        return true;
    }

    public synchronized void setMask(PackedImage packedImage, int n, int n2, float f, float f2) {
        super.setMask(packedImage, n, n2, f, f2);
    }

    public synchronized boolean renderImage(Component component, Image image, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this._mask != null;
        if (this.buffers.size() == 1) {
            return super.renderImage(component, image, n, n2);
        }
        Graphics graphics = image.getGraphics();
        if (graphics == null) {
            IFDInfo.dbg.dprint("Couldn't get graphics for image.  Window died?", DebugInfoPrinter.DBUG_ERROR);
            return false;
        }
        int n3 = n + this.getXpos();
        int n4 = n2 + this.getYpos();
        if (bl) {
            float f = this.getScaleFactorX() / this._mask_xscale;
            float f2 = this.getScaleFactorY() / this._mask_yscale;
            float f3 = this.getScaleFactorY();
            int n5 = 0;
            int n6 = this.buffers.size();
            while (n5 < n6) {
                byte[] byArray = (byte[])this.buffers.elementAt(n5);
                Image image2 = this.getImageFromBuffer(byArray, component);
                if (image2 == null) {
                    IFDInfo.dbg.dprint("IFDInfoJPEG::toImage() -- problem decompressing a tile of a JPEG'ed image.", DebugInfoPrinter.DBUG_ERROR);
                    return false;
                }
                int n7 = this.ifd.getRowsInStrip(n5);
                this.drawImage_masked(image2, this._mask, this._mask_xpos, this._mask_ypos, graphics, component, n3, n4, this.ifd.ImageWidth, n7, f, f2, this._mask_xscale, this._mask_yscale);
                n4 = (int)((float)n4 + (float)n7 * f3);
                ++n5;
            }
        } else {
            float f = this.getScaleFactorX();
            float f4 = this.getScaleFactorY();
            int n8 = 0;
            int n9 = this.buffers.size();
            while (n8 < n9) {
                byte[] byArray = (byte[])this.buffers.elementAt(n8);
                Image image3 = this.getImageFromBuffer(byArray, component);
                if (image3 == null) {
                    IFDInfo.dbg.dprint("IFDInfoJPEG::toImage() -- problem decompressing a tile of a JPEG'ed image.", DebugInfoPrinter.DBUG_ERROR);
                    return false;
                }
                int n10 = this.ifd.getRowsInStrip(n8);
                this.drawImage_simple(image3, graphics, component, n3, n4, this.ifd.ImageWidth, n10, f, f4);
                n4 = (int)((float)n4 + (float)n10 * f);
                ++n8;
            }
        }
        return true;
    }
}

