/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.ifd_info;

import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.util.DebugInfoPrinter;

public class AnnotationTableEntry {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    public static final int LENGTH = 28;
    static final int ID_OFFSET = 0;
    static final int TYPE_OFFSET = 2;
    static final int X_OFFSET = 4;
    static final int Y_OFFSET = 8;
    static final int W_OFFSET = 12;
    static final int H_OFFSET = 16;
    static final int L_OFFSET = 20;
    static final int O_OFFSET = 24;
    public int ID;
    public int type;
    public int x;
    public int y;
    public int width;
    public int height;
    public int length;
    public int offset;
    public byte[] data;
    public boolean isModified;

    public AnnotationTableEntry(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        if (byArray.length != n7) {
            dbg.dprint("Creating bad annot entry " + n, DebugInfoPrinter.DBUG_ANNOTATIONS);
        }
        this.ID = n;
        this.type = n2;
        this.x = n3;
        this.y = n4;
        this.width = n5;
        this.height = n6;
        this.length = n7;
        this.offset = n8;
        this.data = byArray;
        this.isModified = false;
    }

    public AnnotationTableEntry(byte[] byArray, XIFFFile xIFFFile, int n) {
        this.ID = xIFFFile.GetShort(byArray, n);
        this.type = xIFFFile.GetShort(byArray, n + 2);
        this.x = xIFFFile.GetLong(byArray, n + 4);
        this.y = xIFFFile.GetLong(byArray, n + 8);
        this.width = xIFFFile.GetLong(byArray, n + 12);
        this.height = xIFFFile.GetLong(byArray, n + 16);
        this.offset = xIFFFile.GetLong(byArray, n + 24);
        this.length = xIFFFile.GetLong(byArray, n + 20);
        this.data = new byte[this.length];
        this.isModified = false;
    }

    public void setData(byte[] byArray, int n) {
        try {
            System.arraycopy(byArray, n, this.data, 0, this.length);
            return;
        }
        catch (Exception exception) {
            dbg.dprint("Error in AnnotationTableEntry.setData:", DebugInfoPrinter.DBUG_ANNOTATIONS);
            dbg.dprint(exception.toString(), DebugInfoPrinter.DBUG_ANNOTATIONS);
            dbg.dprint("newData:" + new String(byArray, 0), DebugInfoPrinter.DBUG_ANNOTATIONS);
            dbg.dprint("data: " + new String(this.data, 0), DebugInfoPrinter.DBUG_ANNOTATIONS);
            dbg.dprint("start: " + n + "newDatalen: " + byArray.length, DebugInfoPrinter.DBUG_ANNOTATIONS);
            dbg.dprint(" length: " + this.length + " datalen: " + this.data.length, DebugInfoPrinter.DBUG_ANNOTATIONS);
            exception.printStackTrace();
            return;
        }
    }

    public byte[] toByteArray(XIFFFile xIFFFile) {
        byte[] byArray = new byte[28];
        xIFFFile.PutShort(byArray, 0, this.ID);
        xIFFFile.PutShort(byArray, 2, this.type);
        xIFFFile.PutLong(byArray, 4, this.x);
        xIFFFile.PutLong(byArray, 8, this.y);
        xIFFFile.PutLong(byArray, 12, this.width);
        xIFFFile.PutLong(byArray, 16, this.height);
        xIFFFile.PutLong(byArray, 20, this.length);
        xIFFFile.PutLong(byArray, 24, this.offset);
        return byArray;
    }
}

