/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.caching;

import COM.xerox.digipaper.applet.xiff.PageDescriptor;
import COM.xerox.digipaper.applet.xiff.caching.RequestForImage;
import COM.xerox.digipaper.util.CanBeNotified;
import COM.xerox.digipaper.util.CanGetObjects;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;

public class PageImageGetter
extends Thread
implements CanGetObjects,
CanBeNotified {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected boolean running;
    protected CanGetObjects gctop;
    protected CanBeNotified recipient;
    protected RequestForImage rfi;
    protected boolean rendering_image;
    protected Object render_lock;
    protected PageDescriptor pd;
    protected boolean image_should_be_rendered;

    public PageImageGetter(String string, CanGetObjects canGetObjects) {
        super(string);
        this.gctop = canGetObjects;
        this.render_lock = new Object();
        this.image_should_be_rendered = true;
        this.rendering_image = false;
        this.running = false;
    }

    public void run() {
        if (this.rfi.getImage() != null) {
            dbg.dprint("PageImageGetter::run() scaling an existing image", DebugInfoPrinter.DBUG_CACHING_VERBOSE);
            Component component = this.rfi.getComponent();
            Image image = this.rfi.getImage();
            float f = this.rfi.getFactor();
            int n = (int)((float)image.getWidth(component) * f);
            int n2 = (int)((float)image.getHeight(component) * f);
            component.prepareImage(image, n, n2, component);
            this.recipient.Update(true, this.rfi, this.rfi);
            return;
        }
        dbg.dprint("PageImageGetter::run() rendering an image from scratch", DebugInfoPrinter.DBUG_CACHING_VERBOSE);
        try {
            this.pd = this.rfi.getXIFFFile().getPageDescriptor(this.rfi.getPageNumber());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            dbg.dprint("Can't access page " + this.rfi.getPageNumber(), DebugInfoPrinter.ERROR);
            return;
        }
        this.gctop.startGettingObject(this, this.pd);
    }

    public boolean startGettingObject(CanBeNotified canBeNotified, Object object) {
        this.recipient = canBeNotified;
        this.rfi = (RequestForImage)object;
        if (this.running) {
            return false;
        }
        this.start();
        return true;
    }

    public void stopGettingObject(CanBeNotified canBeNotified, Object object) {
        Object object2 = this.render_lock;
        synchronized (object2) {
            if (this.rendering_image) {
                dbg.dprint("PageImageGetter::stopGettingObject() stopping the threads for the PageImageGetter that is getting the image corresponding to " + this.rfi.toString() + ".", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
                this.gctop.stopGettingObject(this, this.pd);
                this.stop();
            } else {
                this.image_should_be_rendered = false;
            }
            return;
        }
    }

    public void Update(boolean bl, Object object, Object object2) {
        Image image = null;
        PageDescriptor pageDescriptor = (PageDescriptor)object2;
        Component component = this.rfi.getComponent();
        float f = this.rfi.getFactor();
        boolean bl2 = false;
        this.rfi.setPageDescriptor(pageDescriptor);
        Object object3 = this.render_lock;
        synchronized (object3) {
            if (!this.image_should_be_rendered) {
                Object var11_11 = null;
                return;
            }
            this.rendering_image = true;
        }
        if (pageDescriptor.page_info == null) {
            bl2 = true;
        } else {
            dbg.dprint("PageImageGetter::Update() calling toImage for page " + pageDescriptor.getPageNumber() + ".", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
            image = pageDescriptor.page_info.toImage(component);
            if (image == null) {
                bl2 = true;
            } else {
                int n = (int)((float)image.getWidth(component) * f);
                int n2 = (int)((float)image.getHeight(component) * f);
                component.prepareImage(image, n, n2, component);
            }
        }
        if (bl2) {
            Graphics graphics;
            dbg.dprint("Couldn't access page: " + pageDescriptor.getPageNumber() + ". Making fake page", DebugInfoPrinter.ERROR);
            image = component.createImage(200, 100);
            if (image != null && (graphics = image.getGraphics()) != null) {
                graphics.drawString("Error accessing page", 20, 80);
            }
        }
        this.rfi.setImage(image);
        this.recipient.Update(true, this.rfi, this.rfi);
    }
}

