/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff;

import COM.xerox.digipaper.applet.client.Client;
import COM.xerox.digipaper.applet.xiff.DelayedBuffer;
import COM.xerox.digipaper.applet.xiff.DictionaryEntry;
import COM.xerox.digipaper.applet.xiff.DiskRangeAccessFile;
import COM.xerox.digipaper.applet.xiff.NetRangeAccessFile;
import COM.xerox.digipaper.applet.xiff.PageDescriptor;
import COM.xerox.digipaper.applet.xiff.RangeAccessFile;
import COM.xerox.digipaper.applet.xiff.TIFFException;
import COM.xerox.digipaper.applet.xiff.TIFFFile;
import COM.xerox.digipaper.applet.xiff.XIFFException;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.TokenDecoder;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import COM.xerox.digipaper.util.caching.GenericCache;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XIFFFile
extends TIFFFile {
    final int PAGE_TABLE = 1;
    final int SYM_LIB = 5;
    final int AUTHOR = 2;
    static final int CURRENT_XIFF_VERSION = 3;
    static final int CURRENT_XIFF_REVISION = 0;
    byte[] zero = new byte[1];
    private String nullstr = new String(this.zero, 0);
    private int _symlib_offset;
    private DelayedBuffer _symlib_dbuffer;
    int _author_doctag_offset;
    int _author_offset;
    private DelayedBuffer _author_dbuffer;
    private int _pagetable_offset;
    private DelayedBuffer _pagetable_dbuffer;
    private Hashtable _authors;
    protected Vector _PageTable;
    protected boolean page_table_read;
    protected int num_pages;
    private Hashtable _sym_lib;
    protected GenericCache TokenDecoders = new GenericCache(Client.DEFAULT_SIZE_OF_TOKEN_DECODER_CACHE);

    public XIFFFile(URL uRL) throws IOException, XIFFException, TIFFException {
        this(new NetRangeAccessFile(uRL));
    }

    public XIFFFile(String string) throws IOException, XIFFException, TIFFException {
        this(new DiskRangeAccessFile(string));
    }

    public XIFFFile(RangeAccessFile rangeAccessFile) throws IOException, XIFFException, TIFFException {
        super(rangeAccessFile);
        this._XIFFFile(rangeAccessFile);
    }

    public void _XIFFFile(RangeAccessFile rangeAccessFile) throws IOException, XIFFException, TIFFException {
        this.TokenDecoders.setStringDefaultDisposer("Flushing a TokenDictionary from the cache for TokenDictionaries.");
        this.num_pages = -1;
        DelayedBuffer delayedBuffer = this.RAFile.ReadRange(8, 14);
        byte[] byArray = delayedBuffer.GetData();
        String string = new String(byArray, 0, 0, 10);
        if (!string.equals(" eXtended ")) {
            throw new XIFFException("Not a xiff file, Bad ID " + string);
        }
        byte by = byArray[10];
        byte by2 = byArray[11];
        if (by != 3) {
            throw new XIFFException("Bad XIFF version " + by + " (expecting " + 3 + ")");
        }
        if (by2 != 0) {
            throw new XIFFException("Bad XIFF revision " + by2 + " (expecting " + 0 + ")");
        }
        this.page_table_read = false;
        this._PageTable = new Vector();
        PageDescriptor pageDescriptor = new PageDescriptor(0, this._offset_to_next_ifd, this);
        this._PageTable.addElement(pageDescriptor);
        int n = this.GetShort(byArray, 12);
        TIFFFile.dbg.dprint("This file has " + n + " XIFF extensions.", DebugInfoPrinter.DBUG_XIFF_VERBOSE);
        delayedBuffer = this.RAFile.ReadRange(22, n * 6);
        byArray = delayedBuffer.GetData();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.GetShort(byArray, n2);
            n2 += 2;
            switch (n4) {
                case 1: {
                    this._pagetable_offset = this.GetLong(byArray, n2);
                    this._pagetable_dbuffer = this.RAFile.ReadRange(this._pagetable_offset, 10);
                    break;
                }
                case 2: {
                    this._author_doctag_offset = 22 + n2;
                    this._author_offset = this.GetLong(byArray, n2);
                    this._author_dbuffer = this.RAFile.ReadRange(this._author_offset, 2);
                    break;
                }
                case 5: {
                    this._symlib_offset = this.GetLong(byArray, n2);
                    this._symlib_dbuffer = this.RAFile.ReadRange(this._symlib_offset, 10);
                    break;
                }
                default: {
                    TIFFFile.dbg.dprint("Unknown extension tag: " + n4, DebugInfoPrinter.DBUG_ERROR);
                }
            }
            n2 += 4;
            ++n3;
        }
    }

    public synchronized int getNumPages() {
        return this.num_pages;
    }

    public synchronized PageDescriptor getPageDescriptor(int n) {
        return (PageDescriptor)this._PageTable.elementAt(n);
    }

    public synchronized void flushTokenDecoders() {
        this.TokenDecoders.flushAllObjects();
    }

    public synchronized void putTokenDecoder(String string, TokenDecoder tokenDecoder) {
        this.TokenDecoders.setObject(string, tokenDecoder);
    }

    public synchronized Object getTokenDecoder(String string) {
        return this.TokenDecoders.getObject(string);
    }

    public synchronized boolean ReadPageTable() throws XIFFException, IOException {
        int n;
        int n2;
        if (this.page_table_read) {
            return true;
        }
        if (this._pagetable_offset == 0) {
            return false;
        }
        byte[] byArray = this._pagetable_dbuffer.GetData();
        this.num_pages = this.GetShort(byArray, 0);
        int n3 = this.GetShort(byArray, 2);
        int n4 = this.GetShort(byArray, 4);
        int n5 = this.GetLong(byArray, 6);
        int n6 = 6 + n3 * 5;
        int n7 = 0;
        TIFFFile.dbg.dprint("Page Table header: num_pages = " + this.num_pages + ", ent_per_table = " + n3 + ", table_offset = " + n5, DebugInfoPrinter.DBUG_XIFF_VERBOSE);
        int n8 = 1;
        while (n8 < n4) {
            this._pagetable_dbuffer = this.RAFile.ReadRange(n5, n6);
            byArray = this._pagetable_dbuffer.GetData();
            if (n8 != this.GetShort(byArray, n2 = 0)) {
                this._pagetable_offset = 0;
                throw new XIFFException("Bad Page table ordinal: " + this.GetShort(byArray, n2));
            }
            n2 += 2;
            n = 0;
            while (n < n3) {
                ++n2;
                if (n7 != 0) {
                    PageDescriptor pageDescriptor = new PageDescriptor(n7, this.GetLong(byArray, n2), this);
                    this._PageTable.addElement(pageDescriptor);
                }
                n2 += 4;
                ++n7;
                ++n;
            }
            n5 = this.GetLong(byArray, n2);
            ++n8;
        }
        this._pagetable_dbuffer = this.RAFile.ReadRange(n5, n6);
        byArray = this._pagetable_dbuffer.GetData();
        if (n4 != this.GetShort(byArray, n2 = 0)) {
            this._pagetable_offset = 0;
            throw new XIFFException("Bad Page table ordinal: " + this.GetShort(byArray, n2));
        }
        n2 += 2;
        n = 0;
        int n9 = (this.num_pages - 1) % n3;
        while (n <= n9) {
            ++n2;
            if (n7 != 0) {
                PageDescriptor pageDescriptor = new PageDescriptor(n7, this.GetLong(byArray, n2), this);
                this._PageTable.addElement(pageDescriptor);
            }
            n2 += 4;
            ++n7;
            ++n;
        }
        this._pagetable_offset = 0;
        this.page_table_read = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hashtable Authors() throws XIFFException {
        if (this._authors != null) {
            return this._authors;
        }
        if (this._author_offset == 0) {
            return null;
        }
        try {
            byte[] byArray = this._author_dbuffer.GetData();
            int n = this.GetShort(byArray, 0);
            this._authors = new Hashtable();
            this._author_dbuffer = this.RAFile.ReadRange(this._author_offset + 2, n);
            byArray = this._author_dbuffer.GetData();
            StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray, 0, 0, n), this.nullstr);
            if (stringTokenizer.countTokens() % 2 == 1) {
                throw new XIFFException("Unbalanced Author list");
            }
            while (true) {
                if (!stringTokenizer.hasMoreTokens()) {
                    return this._authors;
                }
                this._authors.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
            }
        }
        catch (IOException iOException) {
            TIFFFile.dbg.dprint("XIFFFile: exception reading authors", DebugInfoPrinter.DBUG_ERROR);
            iOException.printStackTrace();
            throw new XIFFException("Error reading authors");
        }
    }

    public synchronized Hashtable SymLib() throws XIFFException {
        if (this._sym_lib != null) {
            return this._sym_lib;
        }
        if (this._symlib_offset == 0) {
            return null;
        }
        try {
            int n = 0;
            byte[] byArray = this._symlib_dbuffer.GetData();
            this._sym_lib = new Hashtable();
            int n2 = this.GetShort(byArray, 0);
            int n3 = this.GetShort(byArray, 2);
            int n4 = this.GetShort(byArray, 4);
            int n5 = this.GetLong(byArray, 6);
            int n6 = 6 + n3 * 12;
            int n7 = 0;
            int n8 = 1;
            while (n8 <= n4) {
                int n9;
                this._symlib_dbuffer = this.RAFile.ReadRange(n5, n6);
                byArray = this._symlib_dbuffer.GetData();
                if (n8 != this.GetShort(byArray, n9 = 0)) {
                    throw new XIFFException("Bad Dict table ordinal: " + this.GetShort(byArray, n9));
                }
                n9 += 2;
                int n10 = 0;
                while (n10 < n3) {
                    Integer n11 = new Integer(n7++);
                    DictionaryEntry dictionaryEntry = new DictionaryEntry();
                    dictionaryEntry.size = this.GetLong(byArray, n9);
                    dictionaryEntry.offset = this.GetLong(byArray, n9 += 4);
                    n9 += 4;
                    DictionaryEntry dictionaryEntry2 = this._sym_lib.put(n11, dictionaryEntry);
                    if (dictionaryEntry2 != null) {
                        throw new XIFFException("Repeated entry in DictTable " + dictionaryEntry2);
                    }
                    if (++n >= n2) break;
                    ++n10;
                }
                n5 = this.GetLong(byArray, n9);
                ++n8;
            }
            return this._sym_lib;
        }
        catch (IOException iOException) {
            TIFFFile.dbg.dprint("XIFFFile: exception reading symbol library", DebugInfoPrinter.DBUG_ERROR);
            iOException.printStackTrace();
            throw new XIFFException("Error reading SymLib");
        }
    }
}

