/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff;

import COM.xerox.digipaper.applet.xiff.DelayedBuffer;
import COM.xerox.digipaper.applet.xiff.DiskRangeAccessFile;
import COM.xerox.digipaper.applet.xiff.Entry;
import COM.xerox.digipaper.applet.xiff.FileRange;
import COM.xerox.digipaper.applet.xiff.RangeAccessFile;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTable;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableEntry;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableHeader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SaveToFile {
    public static final int CHUNK_SIZE = 4096;
    public XIFFFile file;
    public Vector holes;
    public int fileSize;
    public String filename;
    public String tempname;
    public RandomAccessFile target;

    public SaveToFile(String string, XIFFFile xIFFFile) {
        try {
            this.filename = string;
            this.file = xIFFFile;
            RangeAccessFile rangeAccessFile = xIFFFile.RAFile;
            this.fileSize = (int)rangeAccessFile.size();
            this.target = new RandomAccessFile(this.getTempFile(), "rw");
            this.holes = new Vector();
            System.out.println("Saving file:" + string);
            int n = this.fileSize / 4096;
            if (4096 * n < this.fileSize) {
                ++n;
            }
            DelayedBuffer[] delayedBufferArray = new DelayedBuffer[n];
            System.out.print("Reading original file: ");
            int n2 = 0;
            while (n2 < n - 1) {
                System.out.print(String.valueOf(n2 * 100 / n) + "% ");
                delayedBufferArray[n2] = rangeAccessFile.ReadRange(n2 * 4096, 4096);
                ++n2;
            }
            System.out.println(". done!");
            delayedBufferArray[n - 1] = rangeAccessFile.ReadRange(n2 * 4096, this.fileSize - n2 * 4096);
            System.out.print("Writing to new file: ");
            int n3 = 0;
            while (n3 < n) {
                System.out.print(String.valueOf(n3 * 100 / n) + "% ");
                this.target.write(delayedBufferArray[n3].GetData());
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println("Error copying original file!");
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
        System.out.println("File copied successfully!");
    }

    public void commit() throws IOException {
        this.target.close();
        File file = new File(this.filename);
        File file2 = new File(this.tempname);
        try {
            if (file.exists()) {
                if (!file.renameTo(new File(String.valueOf(this.filename) + ".bak"))) {
                    System.out.println("Could not back up file: " + this.filename);
                }
                if (!(file = new File(this.filename)).delete()) {
                    System.out.println("Could not delete file: " + this.filename);
                }
            }
            if (!file2.renameTo(file)) {
                System.out.println("Could not rename <" + this.tempname + "> to <" + this.filename + ">");
                throw new IOException("Could not save " + this.filename + ", saved as " + this.tempname);
            }
            file2 = new File(this.tempname);
            if (file2.exists()) {
                System.out.println("Temp still exists." + this.tempname);
                file2.delete();
            }
            this.file.RAFile = new DiskRangeAccessFile(this.filename);
            return;
        }
        catch (IOException iOException) {
            this.file.RAFile = new DiskRangeAccessFile(this.tempname);
            throw iOException;
        }
    }

    public File getTempFile() {
        File file = new File(this.filename);
        String string = file.getParent();
        File file2 = new File(string, "temp.xiff");
        int n = 0;
        while (file2.exists()) {
            file2 = new File(string, "temp" + ++n + ".xiff");
        }
        this.tempname = file2.getPath();
        return file2;
    }

    public void write(AnnotationTableHeader annotationTableHeader) {
        Entry entry = annotationTableHeader.annotTag;
        AnnotationTable annotationTable = annotationTableHeader.table;
        int n = annotationTable.entries.size();
        int n2 = n / annotationTable.numEntries;
        if (n2 * annotationTable.numEntries < n) {
            ++n2;
        }
        int[] nArray = annotationTable.tableOffset;
        annotationTableHeader.count = n;
        annotationTableHeader.last = n2;
        if ((Integer)entry.Value == 0 && n != 0) {
            entry.Value = new Integer(this.fileSize);
            this.UpdateIFDField(entry);
            annotationTableHeader.first = this.fileSize + 10;
            try {
                this.target.seek(this.fileSize);
                this.target.write(annotationTableHeader.toByte(this.file));
                this.fileSize += 10;
            }
            catch (IOException iOException) {
                System.out.println("Error seeking eof");
                System.out.println(iOException.toString());
                iOException.printStackTrace();
            }
            int n3 = 1;
            while (n3 < n2) {
                this.write(annotationTable, n3, this.fileSize, -1);
                ++n3;
            }
            this.write(annotationTable, n3, this.fileSize, 0);
            return;
        }
        if ((Integer)entry.Value == 0 && n == 0) {
            return;
        }
        try {
            this.target.seek(((Integer)entry.Value).intValue());
            this.target.write(annotationTableHeader.toByte(this.file));
        }
        catch (IOException iOException) {
            System.out.println("Could not overwrite header");
            System.out.println(iOException.toString());
            iOException.printStackTrace();
        }
        int n4 = n2;
        while (n4 < nArray.length - 1) {
            this.holes.addElement(new FileRange(nArray[n4], annotationTable.tableLen));
            ++n4;
        }
        n4 = 1;
        while (n4 <= n2) {
            int n5 = n4 == n2 ? 0 : (n4 > nArray.length - 1 ? -1 : nArray[n4]);
            int n6 = n4 < nArray.length ? nArray[n4 - 1] : this.fileSize;
            this.write(annotationTable, n4, n6, n5);
            ++n4;
        }
    }

    public void UpdateIFDField(Entry entry) {
        if (entry.Offset == 0) {
            System.out.println("Cannot update entry if it did not exist before");
            return;
        }
        try {
            this.target.seek(entry.Offset);
            int n = 0;
            int n2 = 2;
            int n3 = 4;
            int n4 = 8;
            byte[] byArray = new byte[12];
            this.file.PutShort(byArray, n, entry.Tag);
            this.file.PutShort(byArray, n2, entry.Type);
            this.file.PutLong(byArray, n3, entry.Count);
            this.file.PutLong(byArray, n4, (Integer)entry.Value);
            this.target.write(byArray);
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error updating IFD field, tag = " + entry.Tag);
            System.out.println(iOException.toString());
            iOException.printStackTrace();
            return;
        }
    }

    public void write(Hashtable hashtable) {
        int n;
        byte[] byArray;
        DelayedBuffer delayedBuffer;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            int n2 = string.length();
            byte[] byArray3 = new byte[n2];
            string.getBytes(0, n2, byArray3, 0);
            byteArrayOutputStream.write(byArray3, 0, n2);
            byteArrayOutputStream.write(byArray2, 0, 1);
            n2 = string2.length();
            byArray3 = new byte[n2];
            string2.getBytes(0, n2, byArray3, 0);
            byteArrayOutputStream.write(byArray3, 0, n2);
            byteArrayOutputStream.write(byArray2, 0, 1);
        }
        byteArrayOutputStream.write(byArray2, 0, 1);
        try {
            delayedBuffer = this.file.RAFile.ReadRange(this.file._author_offset, 2);
        }
        catch (IOException iOException) {
            System.err.println("Error reading size of author block");
            System.err.println(iOException.toString());
            iOException.printStackTrace();
            delayedBuffer = null;
        }
        int n3 = this.file._author_offset;
        if (n3 != 0 && delayedBuffer != null) {
            try {
                byArray = delayedBuffer.GetData();
                n = this.file.GetShort(byArray, 0);
            }
            catch (IOException iOException) {
                System.err.println("Error reading delayedbuffer for author block size");
                System.err.println(iOException.toString());
                iOException.printStackTrace();
                n = 0;
            }
        } else {
            n = 0;
        }
        if (n < byteArrayOutputStream.size()) {
            this.holes.addElement(new FileRange(n3, n + 2));
            byte[] byArray4 = new byte[4];
            this.file.PutLong(byArray4, 0, this.fileSize);
            try {
                this.target.seek(this.file._author_doctag_offset);
                this.target.write(byArray4);
            }
            catch (IOException iOException) {
                System.err.println("Error writing author doctag offset");
                System.err.println(iOException.toString());
                iOException.printStackTrace();
            }
            n3 = this.fileSize;
            this.fileSize += byteArrayOutputStream.size() + 2;
        } else if (n > byteArrayOutputStream.size()) {
            this.holes.addElement(new FileRange(n3 + byteArrayOutputStream.size() + 2, n - byteArrayOutputStream.size()));
        }
        System.out.println("Writing Author block to File!");
        System.out.println("=============================");
        System.out.println("Author Offset = " + n3);
        System.out.println("Author Doctag Offset = " + this.file._author_doctag_offset);
        System.out.println("Data size = " + byteArrayOutputStream.size());
        System.out.println("Old size = " + n);
        try {
            byArray = new byte[2];
            this.file.PutShort(byArray, 0, byteArrayOutputStream.size());
            this.target.seek(n3);
            this.target.write(byArray);
            this.target.seek(n3 + 2);
            this.target.write(byteArrayOutputStream.toByteArray());
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error writing author block");
            System.err.println(iOException.toString());
            iOException.printStackTrace();
            return;
        }
    }

    public void write(AnnotationTable annotationTable, int n, int n2, int n3) {
        byte[] byArray;
        Object object;
        System.out.println("writing annt table ord = " + n + " off = " + n2 + " next = " + n3);
        int n4 = (n - 1) * annotationTable.numEntries;
        int n5 = n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(annotationTable.spaceNeeded);
        if (n2 == this.fileSize) {
            this.fileSize += annotationTable.tableLen;
        }
        int n6 = this.fileSize;
        try {
            this.target.seek(n5);
            object = new byte[2];
            this.file.PutShort((byte[])object, 0, n);
            this.target.write((byte[])object);
            n5 += 2;
        }
        catch (IOException iOException) {
            System.err.println("Error writing table ordinal" + n);
            System.err.println(iOException.toString());
            iOException.printStackTrace();
        }
        int n7 = 0;
        while (n7 < annotationTable.numEntries) {
            try {
                object = (AnnotationTableEntry)annotationTable.entries.elementAt(n7 + n4);
                ((AnnotationTableEntry)object).ID = n7 + n4 + 1;
                if (((AnnotationTableEntry)object).offset == 0) {
                    ((AnnotationTableEntry)object).offset = n6;
                    n6 += ((AnnotationTableEntry)object).length;
                    byteArrayOutputStream.write(((AnnotationTableEntry)object).data, 0, ((AnnotationTableEntry)object).length);
                } else if (((AnnotationTableEntry)object).isModified) {
                    this.target.seek(((AnnotationTableEntry)object).offset);
                    this.target.write(((AnnotationTableEntry)object).data);
                    this.target.seek(n5);
                }
                System.out.println("Entry #" + ((AnnotationTableEntry)object).ID + " offset=" + ((AnnotationTableEntry)object).offset + " length=" + ((AnnotationTableEntry)object).length);
                ((AnnotationTableEntry)object).isModified = false;
                this.target.seek(n5);
                this.target.write(((AnnotationTableEntry)object).toByteArray(this.file));
                n5 += 28;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                try {
                    System.out.println("Entry #" + (n7 + n4 + 1) + " <empty>");
                    byArray = new byte[28];
                    int n8 = 0;
                    while (n8 < 28) {
                        byArray[n8] = (byte)n8;
                        ++n8;
                    }
                    this.target.seek(n5);
                    this.target.write(byArray);
                    n5 += 28;
                }
                catch (IOException iOException) {
                    System.err.println("Error writing empty annotations");
                    System.err.println(iOException.toString());
                    iOException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                System.err.println("Error writing annotation table");
                System.err.println("Ordinal=" + n + ", " + n7);
                System.err.println(iOException.toString());
                iOException.printStackTrace();
            }
            ++n7;
        }
        if (n3 < 0) {
            n3 = n6;
        }
        try {
            this.target.seek(n5);
            byArray = new byte[4];
            this.file.PutLong(byArray, 0, n3);
            this.target.write(byArray);
            n5 += 4;
        }
        catch (IOException iOException) {
            System.err.println("Error writing next table offset");
            System.err.println("Ordinal=" + n + ", " + n7);
            System.err.println(iOException.toString());
            iOException.printStackTrace();
        }
        try {
            this.target.seek(this.fileSize);
            this.target.write(byteArrayOutputStream.toByteArray(), 0, n6 - this.fileSize);
            System.out.println("Appended annots space used=" + (n6 - this.fileSize) + ", space needed=" + annotationTable.spaceNeeded);
            System.out.println("file size = " + this.target.length() + ", predicted=" + n6);
            annotationTable.spaceNeeded -= n6 - this.fileSize;
        }
        catch (IOException iOException) {
            System.err.println("Error writing appended annotations");
            System.err.println("Ordinal=" + n + ", " + n7);
            System.err.println(iOException.toString());
            iOException.printStackTrace();
        }
        this.fileSize = n6;
    }
}

