/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff;

import COM.xerox.digipaper.applet.xiff.PageDescriptor;
import COM.xerox.digipaper.applet.xiff.PageInfoReader;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.caching.RequestForImage;
import COM.xerox.digipaper.util.BinarySemaphore;
import COM.xerox.digipaper.util.CanBeNotified;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import COM.xerox.digipaper.util.caching.CanPrefetchObjects;
import java.awt.Component;
import java.awt.Image;

public class RenderThread
implements Runnable,
CanBeNotified {
    protected float factor;
    int new_current_page;
    int current_page;
    int prev_prefetched_page1;
    int prev_prefetched_page2;
    protected boolean stopped_prefetching;
    protected BinarySemaphore sem;
    protected PageInfoReader pi_reader;
    protected CanPrefetchObjects prefetcher;
    protected Image image;
    public PageDescriptor page_descriptor;
    XIFFFile xiff_file;
    Component display;
    public int num_pages;
    boolean _done = false;
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected static int thread_id;

    static synchronized int getNextThreadId() {
        return thread_id++;
    }

    public RenderThread(XIFFFile xIFFFile, int n, Component component, CanPrefetchObjects canPrefetchObjects, PageInfoReader pageInfoReader) {
        this.xiff_file = xIFFFile;
        this.display = component;
        this.new_current_page = n;
        this.prefetcher = canPrefetchObjects;
        this.factor = 1.0f;
        this.prev_prefetched_page1 = -1;
        this.prev_prefetched_page2 = -1;
        this.pi_reader = pageInfoReader;
        this.stopped_prefetching = false;
        this.sem = new BinarySemaphore();
    }

    public String getNameForNewRenderThread() {
        return "RenderThread #" + RenderThread.getNextThreadId();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = this.factor;
        RenderThread.dbg.dprint("RenderThread starting...", DebugInfoPrinter.DBUG_CONTROL);
        try {
            this.xiff_file.ReadPageTable();
            this.num_pages = this.xiff_file.getNumPages();
        }
        catch (Exception var2_2) {
            RenderThread.dbg.dprint("error reading page table", DebugInfoPrinter.ERROR);
            var2_2.printStackTrace();
            return;
        }
        this.page_descriptor = null;
        this.current_page = this.new_current_page;
        this.start_getting_page(this.current_page);
        ** GOTO lbl25
        {
            this.sem.P();
            do {
                if (this.new_current_page == this.current_page && this.factor == var1_1 && !this._done) continue block2;
                if (this._done) break block2;
                RenderThread.dbg.dprint("getting page: " + this.new_current_page, DebugInfoPrinter.DBUG_CONTROL);
                var1_1 = this.factor;
                this.current_page = this.new_current_page;
                this.stop_prefetching_previously_requested_as_nec(this.current_page);
                this.start_getting_page(this.current_page);
lbl25:
                // 2 sources

            } while (!this._done);
        }
    }

    protected void stop_prefetching_previously_requested_as_nec(int n) {
        if (this.prev_prefetched_page1 != n - 1 && this.prev_prefetched_page1 != n + 1 && this.prev_prefetched_page1 != n) {
            this.prefetcher.stopGettingObject(this, new RequestForImage(this.display, this.xiff_file, this.prev_prefetched_page1, this.factor));
        }
        if (this.prev_prefetched_page2 != n - 1 && this.prev_prefetched_page2 != n + 1 && this.prev_prefetched_page2 != n) {
            this.prefetcher.stopGettingObject(this, new RequestForImage(this.display, this.xiff_file, this.prev_prefetched_page2, this.factor));
        }
    }

    protected void start_getting_page(int n) {
        RequestForImage requestForImage = new RequestForImage(this.display, this.xiff_file, n, this.factor);
        dbg.dprint("RenderThread -- starting a thread to **GET** page " + n + ".", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
        if (!this.prefetcher.startGettingObject(this, requestForImage)) {
            dbg.dprint("RenderThread::start_getting_page() returns (false).", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
        }
    }

    protected void start_prefetching_pages(int n, int n2) {
        RequestForImage requestForImage;
        if (this.stopped_prefetching) {
            return;
        }
        if (n < this.num_pages && n >= 0) {
            dbg.dprint("RenderThread -- starting a thread to **PREFETCH** page " + n + ".", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
            requestForImage = new RequestForImage(this.display, this.xiff_file, n, this.factor);
            this.prefetcher.prefetchObject(requestForImage);
            this.prev_prefetched_page1 = n;
        }
        if (n2 < this.num_pages && n2 >= 0) {
            dbg.dprint("RenderThread -- starting a thread to **PREFETCH** page " + n2 + ".", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
            requestForImage = new RequestForImage(this.display, this.xiff_file, n2, this.factor);
            this.prefetcher.prefetchObject(requestForImage);
            this.prev_prefetched_page2 = n2;
        }
    }

    protected void stop_getting_page(int n) {
        RequestForImage requestForImage = new RequestForImage(this.display, this.xiff_file, n, this.factor);
        this.prefetcher.stopGettingObject(this, requestForImage);
    }

    public void stop_everything() {
        this.stop_getting_page(this.current_page);
        this.stop_prefetching();
    }

    public void kill() {
        this.stop_everything();
        RenderThread renderThread = this;
        synchronized (renderThread) {
            this._done = true;
            this.sem.V();
            return;
        }
    }

    public void stop_prefetching() {
        this.stopped_prefetching = true;
        this.stop_prefetching_previously_requested_as_nec(-4);
    }

    public void SetCurrentPage(int n) {
        this.stopped_prefetching = false;
        RenderThread renderThread = this;
        synchronized (renderThread) {
            this.new_current_page = n;
            this.sem.V();
            return;
        }
    }

    public void Update(boolean bl, Object object, Object object2) {
        RequestForImage requestForImage = (RequestForImage)object2;
        Image image = requestForImage.getImage();
        PageDescriptor pageDescriptor = requestForImage.getPageDescriptor();
        int n = pageDescriptor.getPageNumber();
        dbg.dprint("RenderThread::Update() starts (page number is " + pageDescriptor.getPageNumber() + ").", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
        if (this.current_page == n) {
            this.page_descriptor = pageDescriptor;
            if (image == null) {
                dbg.dprint("RenderThread::Update() no image for page #" + pageDescriptor.getPageNumber() + ".", DebugInfoPrinter.DBUG_ERROR);
                return;
            }
            this.image = image;
            this.display.repaint();
            if (n == 0) {
                this.start_prefetching_pages(1, 2);
            } else if (n == this.num_pages - 1) {
                this.start_prefetching_pages(n - 1, n - 2);
            } else {
                this.start_prefetching_pages(n - 1, n + 1);
            }
        } else {
            dbg.dprint("RenderThread::Update() WART:current_page != page", DebugInfoPrinter.DBUG_CONTROL);
        }
        this.pi_reader.ReadAnnotationHeader(pageDescriptor, this.xiff_file, this.display);
        dbg.dprint("RenderThread::Update() ends.", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
    }

    public Image getImage() {
        return this.image;
    }

    public void setFactor(float f) {
        RenderThread renderThread = this;
        synchronized (renderThread) {
            this.factor = f;
            this.sem.V();
            return;
        }
    }
}

