/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff;

import COM.xerox.digipaper.applet.xiff.DelayedBuffer;
import COM.xerox.digipaper.applet.xiff.NetDelayedBuffer;
import COM.xerox.digipaper.applet.xiff.RangeAccessFile;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class NetRangeAccessFile
implements RangeAccessFile {
    String file;
    URLConnection connection;
    byte[] buffer;
    long size;
    InputStream is;
    int pos;
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);

    public long size() {
        return this.size;
    }

    public NetRangeAccessFile(URL uRL) throws IOException {
        try {
            dbg.dprint("Requesting file from server: " + uRL.toString(), DebugInfoPrinter.DBUG_CONTROL);
            this.connection = uRL.openConnection();
            this.connection.connect();
            this.size = this.connection.getContentLength();
            dbg.dprint("Content-Length: " + this.size, DebugInfoPrinter.DBUG_XIFF);
            if (this.size < 0L) {
                throw new IOException("Error getting file from server\n");
            }
            this.is = this.connection.getInputStream();
            this.buffer = new byte[(int)this.size];
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("NetRangeAccessFile: error opening http connection");
        }
    }

    public DelayedBuffer ReadRange(int n, int n2) throws IOException {
        return new NetDelayedBuffer(n, n2, this);
    }

    public byte[] read(int n, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        NetRangeAccessFile netRangeAccessFile = this;
        synchronized (netRangeAccessFile) {
            while (n + n2 > this.pos) {
                int n3 = this.is.read(this.buffer, this.pos, n + n2 - this.pos);
                if (n3 <= 0) {
                    throw new IOException("NetRangeAccessFile: End of file?");
                }
                this.pos += n3;
            }
        }
        System.arraycopy(this.buffer, n, byArray, 0, n2);
        return byArray;
    }
}

