/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff;

import COM.xerox.digipaper.applet.WJRim.MaskingImageFilter;
import COM.xerox.digipaper.applet.WJRim.MaskingImageFilterWithBoundsChecking;
import COM.xerox.digipaper.applet.WJRim.PackedImage;
import COM.xerox.digipaper.applet.xiff.IFD;
import COM.xerox.digipaper.applet.xiff.ifd_info.IFDInfoBinaryImage;
import COM.xerox.digipaper.util.BinarySemaphore;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;

public class IFDInfo
implements ImageObserver {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected IFD ifd;
    protected IFDInfo ii_trans_mask;
    protected String error_msg;
    protected boolean error_preparing_image;
    protected boolean rendering_is_noop;
    protected PackedImage _mask;
    protected BinarySemaphore sem;
    protected int _mask_xpos;
    protected int _mask_ypos;
    protected float _mask_xscale;
    protected float _mask_yscale;
    protected float xres_of_master_image;
    protected float yres_of_master_image;

    protected IFDInfo(IFD iFD, String string, boolean bl) {
        this.ifd = iFD;
        this.error_msg = string;
        this.rendering_is_noop = bl;
        this._mask = null;
        this._mask_xpos = 0;
        this._mask_ypos = 0;
        this.ii_trans_mask = null;
        this.xres_of_master_image = iFD.XResolution().toFloat();
        this.yres_of_master_image = iFD.YResolution().toFloat();
        this.sem = new BinarySemaphore();
    }

    protected void finalize() throws Throwable {
        dbg.dprint("GARBAGE-COLLECTING a " + this.getClass().getName() + ".", DebugInfoPrinter.DBUG_GC);
    }

    protected IFDInfo(IFD iFD, boolean bl) {
        this(iFD, null, bl);
    }

    public IFDInfo(IFD iFD, String string) {
        this(iFD, string, true);
    }

    public IFDInfo(IFD iFD) {
        this(iFD, null);
    }

    public IFD getIFD() {
        return this.ifd;
    }

    public String getErrorMessage() {
        return this.error_msg;
    }

    public void setErrorMessage(String string) {
        this.error_msg = string;
    }

    public void setXResolutionOfMasterImage(float f) {
        this.xres_of_master_image = f;
    }

    public void setYResolutionOfMasterImage(float f) {
        this.yres_of_master_image = f;
    }

    public float getScaleFactorX() {
        return this.xres_of_master_image / this.ifd.XResolution().toFloat();
    }

    public float getScaleFactorY() {
        return this.yres_of_master_image / this.ifd.YResolution().toFloat();
    }

    public void setTransparencyMask(IFDInfo iFDInfo) {
        this.ii_trans_mask = iFDInfo;
    }

    public boolean renderImage(Component component, Image image) {
        return this.renderImage(component, image, 0, 0);
    }

    public boolean renderImage(Component component, Image image, int n, int n2) {
        Object object;
        if (!this.mustCreateImage()) {
            return this.rendering_is_noop;
        }
        Image image2 = this.createImage(component);
        if (image2 == null) {
            return false;
        }
        if (this.ii_trans_mask != null) {
            if (!(this.ii_trans_mask instanceof IFDInfoBinaryImage)) {
                dbg.dprint("IFDInfo -- renderImage() found transparency mask that is not a binary image (instead, it's a " + this.ii_trans_mask.getClass().getName() + ").", DebugInfoPrinter.DBUG_ERROR);
                return false;
            }
            object = new MaskingImageFilter(((IFDInfoBinaryImage)this.ii_trans_mask).getPackedImage());
            FilteredImageSource filteredImageSource = new FilteredImageSource(image2.getSource(), (ImageFilter)object);
            image2 = component.createImage(filteredImageSource);
        }
        if ((object = image.getGraphics()) == null) {
            dbg.dprint("IFDInfo::renderImage(): Graphics null.  Window dead?", DebugInfoPrinter.DBUG_ERROR);
            return false;
        }
        if (this._mask == null) {
            return this.drawImage_simple(image2, (Graphics)object, component, n + this.getXpos(), n + this.getYpos(), this.getWidth(), this.getHeight(), this.getScaleFactorX(), this.getScaleFactorY());
        }
        return this.drawImage_masked(image2, this._mask, this._mask_xpos, this._mask_ypos, (Graphics)object, component, n + this.getXpos(), n + this.getYpos(), this.getWidth(), this.getHeight(), this.getScaleFactorX() / this._mask_xscale, this.getScaleFactorY() / this._mask_yscale, this._mask_xscale, this._mask_yscale);
    }

    public boolean drawImage_masked(Image image, PackedImage packedImage, int n, int n2, Graphics graphics, Component component, int n3, int n4, int n5, int n6, float f, float f2, float f3, float f4) {
        Object object;
        Image image2;
        int n7;
        int n8;
        dbg.dprint("IFDInfo::drawImage_masked() preparing image at (" + n3 + "," + n4 + ")...", DebugInfoPrinter.DBUG_GRAPHICS_VERBOSE);
        if ((double)f != 1.0 || (double)f2 != 1.0) {
            n8 = (int)((float)n5 * f);
            n7 = (int)((float)n6 * f2);
            image2 = component.createImage(n8, n7);
            if (image2 == null) {
                dbg.dprint("IFDInfo::drawImage_masked(): Image null.  Window dead?", DebugInfoPrinter.DBUG_ERROR);
                return false;
            }
            object = image2.getGraphics();
            if (object == null) {
                dbg.dprint("IFDInfo::drawImage_masked(): Graphics null.  Window dead?", DebugInfoPrinter.DBUG_ERROR);
                return false;
            }
            if (!this.drawImage_simple(image, (Graphics)object, component, 0, 0, n5, n6, f, f2)) {
                return false;
            }
        } else {
            n8 = n5;
            n7 = n6;
            image2 = image;
        }
        object = new MaskingImageFilterWithBoundsChecking(packedImage, n - n3, n2 - n4, true);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image2.getSource(), (ImageFilter)object);
        Image image3 = component.createImage(filteredImageSource);
        if (!component.prepareImage(image3, this)) {
            this.sem.P();
        }
        dbg.dprint("IFDInfo::drawImage_masked() notified", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
        if (this.error_preparing_image) {
            return false;
        }
        n8 = (int)((float)n8 * f3);
        n7 = (int)((float)n7 * f4);
        graphics.drawImage(image3, n3, n4, n8, n7, component);
        return true;
    }

    public boolean drawImage_simple(Image image, Graphics graphics, Component component, int n, int n2, int n3, int n4, float f, float f2) {
        int n5 = (int)((float)n3 * f);
        int n6 = (int)((float)n4 * f2);
        dbg.dprint("IFDInfo::drawImage_simple() preparing image at (" + n + "," + n2 + ") with dimensions (" + n5 + "," + n6 + ")...", DebugInfoPrinter.DBUG_GRAPHICS_VERBOSE);
        if (!component.prepareImage(image, this)) {
            this.sem.P();
        }
        dbg.dprint("IFDInfo::drawImage_simple() notified", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
        if (this.error_preparing_image) {
            return false;
        }
        graphics.drawImage(image, n, n2, n5, n6, component);
        return true;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x40) == 64 || (n & 0x80) == 128) {
            this.error_preparing_image = true;
            this.sem.V();
            return false;
        }
        if ((n & 0x20) == 32 || (n & 0x10) == 16) {
            this.error_preparing_image = false;
            this.sem.V();
        }
        return true;
    }

    public Image createImage(Component component) {
        return null;
    }

    public boolean mustCreateImage() {
        return false;
    }

    public boolean mayBeMasked() {
        return false;
    }

    public void setMask(PackedImage packedImage, int n, int n2, float f, float f2) {
        this._mask = packedImage;
        this._mask_xpos = n;
        this._mask_ypos = n2;
        this._mask_xscale = f;
        this._mask_yscale = f2;
    }

    public int getXpos() {
        int n = this.ifd.XPosition();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public int getYpos() {
        int n = this.ifd.YPosition();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public int getWidth() {
        return this.ifd.ImageWidth;
    }

    public int getHeight() {
        return this.ifd.ImageLength;
    }
}

