/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import COM.xerox.digipaper.applet.client.AccessCommandBar;
import COM.xerox.digipaper.applet.client.Client;
import COM.xerox.digipaper.applet.editor.EditAuthorDialog;
import COM.xerox.digipaper.applet.editor.EditCommandBar;
import COM.xerox.digipaper.applet.editor.LinkEditor;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.io.IOException;
import java.util.Hashtable;

class MenuAccessCommandBar
extends AccessCommandBar {
    boolean fileModified;
    boolean authorModified;
    MenuBar mb;
    Menu mFile;
    Menu mToolbars;
    Menu mHelp;
    MenuItem miOpenFile;
    MenuItem miOpenURL;
    MenuItem miSave;
    MenuItem miSaveAs;
    MenuItem miDocInfo;
    MenuItem miEditDocInfo;
    MenuItem miExit;
    Button bSave;
    CheckboxMenuItem cmiStandard;
    CheckboxMenuItem cmiEdit;
    CheckboxMenuItem cmiFile;
    MenuItem miAbout;
    MenuItem miHelp;
    int minHeight;
    public EditCommandBar pEdit;

    public MenuAccessCommandBar(Client client) {
        super(client);
    }

    public void disableEdit() {
        this.cmiEdit.disable();
        this.pEdit.imageCanvas.ToggleEdit("None");
        this.pEdit.hide();
        this.invalidate();
        this.viewer.window.validate();
    }

    public void enableEdit() {
        this.cmiEdit.enable();
        this.DoEditToolbar();
    }

    protected void DoOpen(XIFFFile xIFFFile, String string, String string2) throws Exception {
        super.DoOpen(xIFFFile, string, string2);
        this.pEdit.doEdit();
        this.authorModified = false;
        this.fileModified = false;
        this.miSaveAs.enable();
        this.bSave.enable();
        if (string == null) {
            this.miSave.disable();
            return;
        }
        this.miSave.enable();
    }

    public void setMenuBar(Frame frame) {
        frame.setMenuBar(this.mb);
    }

    public void init() {
        super.init();
        this.minHeight = 200;
        this.resize(this.size().width, 200);
        this.bSave = new Button("Save As...");
        this.pFile.add(this.bSave);
        this.mb = new MenuBar();
        this.mFile = new Menu("File");
        this.mb.add(this.mFile);
        this.miOpenFile = new MenuItem("Open File...");
        this.miOpenURL = new MenuItem("Open URL...");
        this.miSave = new MenuItem("Save");
        this.miSaveAs = new MenuItem("Save As...");
        this.miDocInfo = new MenuItem("Info...");
        this.miEditDocInfo = new MenuItem("Edit Info...");
        this.miExit = new MenuItem("Exit");
        this.mFile.add(this.miOpenFile);
        this.mFile.add(this.miOpenURL);
        this.mFile.add(new MenuItem("-"));
        this.mFile.add(this.miSave);
        this.mFile.add(this.miSaveAs);
        this.mFile.add(new MenuItem("-"));
        this.mFile.add(this.miDocInfo);
        this.mFile.add(this.miEditDocInfo);
        this.mFile.add(new MenuItem("-"));
        this.mFile.add(this.miExit);
        this.miSave.disable();
        this.miSaveAs.disable();
        this.bSave.disable();
        this.mToolbars = new Menu("Toolbars", true);
        this.mb.add(this.mToolbars);
        this.cmiStandard = new CheckboxMenuItem("Standard");
        this.cmiFile = new CheckboxMenuItem("File");
        this.cmiEdit = new CheckboxMenuItem("Edit");
        this.cmiStandard.setState(true);
        this.cmiFile.setState(false);
        this.cmiEdit.setState(true);
        this.mToolbars.add(this.cmiFile);
        this.mToolbars.add(this.cmiStandard);
        this.mToolbars.add(this.cmiEdit);
        this.mHelp = new Menu("Help");
        this.mb.add(this.mHelp);
        this.mb.setHelpMenu(this.mHelp);
        this.miAbout = new MenuItem("About LinkEditor");
        this.miHelp = new MenuItem("Help");
        this.mHelp.add(this.miAbout);
        this.mHelp.add(this.miHelp);
        this.miAbout.disable();
        this.miHelp.disable();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add("North", this.pFile);
        this.pFile.hide();
        this.add("Center", this.pStandard);
        this.pEdit = new EditCommandBar(this.viewer);
        this.add("South", this.pEdit);
        this.pEdit.ToggleEdit(true);
        this.invalidate();
        this.validate();
    }

    public void setModified() {
        if (this.curFilename != null) {
            this.miSave.enable();
        }
        this.fileModified = true;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.miHelp) {
            this.DoHelp();
        } else if (event.target == this.miExit) {
            this.viewer.kill();
        } else if (event.target == this.miOpenFile) {
            this.DoOpenFileWindow();
        } else if (event.target == this.miOpenURL) {
            this.DoOpenURLWindow();
        } else if (event.target == this.miSave) {
            this.DoSave(this.curFilename);
        } else if (event.target == this.miSaveAs || event.target == this.bSave) {
            this.DoSaveAsWindow();
        } else if (event.target == this.miEditDocInfo) {
            this.DoEditDocInfo();
        } else if (event.target == this.miDocInfo) {
            this.DoDocInfo();
        } else if (event.target == this.miAbout) {
            this.DoAbout();
        } else if (event.target == this.cmiStandard) {
            this.DoStandardToolbar();
        } else if (event.target == this.cmiEdit) {
            this.DoEditToolbar();
        } else if (event.target == this.cmiFile) {
            this.DoFileToolbar();
        } else {
            return super.action(event, object);
        }
        return true;
    }

    protected void DoEditDocInfo() {
        if (this.authors == null) {
            try {
                this.authors = this.curFile.Authors();
                if (this.authors == null) {
                    this.authors = new Hashtable();
                }
            }
            catch (Exception exception) {
                this.authors = new Hashtable();
            }
        }
        EditAuthorDialog editAuthorDialog = new EditAuthorDialog((LinkEditor)this.viewer, this.authors);
        editAuthorDialog.show();
        if (editAuthorDialog.isOk) {
            this.authors = editAuthorDialog.table.table;
            this.authorModified = true;
            this.setModified();
        }
    }

    protected void DoSave(String string) {
        try {
            if (this.authorModified) {
                ((LinkEditor)this.viewer).imageCanvas.saveFile(string, this.authors);
            } else {
                ((LinkEditor)this.viewer).imageCanvas.saveFile(string);
            }
            this.curFilename = string;
            this.viewer.printMessage("File saved as <" + string + ">");
            System.out.println("File save completed");
            return;
        }
        catch (IOException iOException) {
            this.viewer.printMessage("Error saving file.");
            System.err.println("Error saving: " + iOException.toString());
            iOException.printStackTrace();
            return;
        }
    }

    protected void DoSaveAsWindow() {
        FileDialog fileDialog = new FileDialog((Frame)this.viewer.window, "Save As...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() != null ? String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile() : fileDialog.getFile();
            this.DoSave(string);
        }
    }

    protected void DoFileToolbar() {
        if (this.cmiFile.getState()) {
            this.pFile.show();
            this.minHeight += 50;
        } else {
            this.minHeight -= 50;
            this.pFile.hide();
        }
        this.invalidate();
        this.viewer.window.validate();
    }

    protected void DoEditToolbar() {
        if (this.cmiEdit.getState()) {
            this.pEdit.show();
            this.pEdit.ToggleEdit(true);
            this.minHeight += 100;
        } else {
            this.minHeight -= 100;
            this.pEdit.hide();
            this.pEdit.ToggleEdit(false);
        }
        this.invalidate();
        this.viewer.window.validate();
    }

    protected void DoStandardToolbar() {
        if (this.cmiStandard.getState()) {
            this.pStandard.show();
        } else {
            this.pStandard.hide();
        }
        this.invalidate();
        this.viewer.window.validate();
    }
}

