/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HashGUI
extends Panel {
    public static String NEW_KEY = new String("add");
    static int SHOWING = 5;
    public Hashtable table;
    Hashtable panels;
    CheckboxGroup keyGroup;
    Checkbox cAdd;
    Vector vData;
    Panel pData;
    Scrollbar scroll;
    int top;

    public HashGUI(Hashtable hashtable) {
        this.table = (Hashtable)hashtable.clone();
        this.keyGroup = new CheckboxGroup();
        this.setLayout(new BorderLayout());
        this.pData = new Panel();
        this.pData.setLayout(new FlowLayout(0, 0, 0));
        this.add("Center", this.pData);
        this.scroll = new Scrollbar();
        this.add("East", this.scroll);
        this.top = 0;
        this.vData = new Vector();
        this.cAdd = new Checkbox(NEW_KEY, this.keyGroup, true);
        this.panels = new Hashtable();
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(this.cAdd);
        this.add("North", panel);
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.table.get(string);
            this.addPanel(string, string2);
        }
        this.updateScrollbar(this.top);
    }

    public Dimension minimumSize() {
        return new Dimension(300, 22 * (SHOWING + 1));
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.updateScrollbar((Integer)event.arg);
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target != this) {
            super.action(event, object);
            return this.postEvent(new Event(this, 1001, null));
        }
        return false;
    }

    public String current() {
        return this.keyGroup.getCurrent().getLabel();
    }

    public String value() {
        return (String)this.table.get(this.current());
    }

    public void remove() {
        if (this.keyGroup.getCurrent() == this.cAdd) {
            System.err.println("You can't remove the add checkbox!");
        } else {
            this.removeKey(this.current());
            this.keyGroup.setCurrent(this.cAdd);
        }
        this.updateScrollbar(this.top);
    }

    public void add(String string, String string2) {
        if (this.keyGroup.getCurrent() != this.cAdd) {
            Checkbox checkbox = new Checkbox(string, this.keyGroup, false);
            Panel panel = (Panel)this.panels.get(this.current());
            this.panels.remove(this.current());
            this.panels.put(string, panel);
            this.table.remove(this.current());
            this.table.put(string, string2);
            panel.removeAll();
            panel.add(checkbox);
            panel.add(new Label(String.valueOf(string2) + "                                   "));
            panel.invalidate();
            this.pData.invalidate();
            this.invalidate();
            this.keyGroup.setCurrent(checkbox);
        } else {
            if (this.table.containsKey(string)) {
                this.removeKey(string);
            }
            this.addPanel(string, string2);
            this.keyGroup.setCurrent(this.cAdd);
        }
        this.table.put(string, string2);
        this.updateScrollbar(this.top);
    }

    public void removeKey(String string) {
        Panel panel = (Panel)this.panels.get(string);
        this.table.remove(string);
        this.panels.remove(string);
        this.pData.remove(panel);
        this.vData.removeElement(panel);
        this.pData.invalidate();
        this.invalidate();
    }

    public Checkbox addPanel(String string, String string2) {
        Panel panel = new Panel();
        Checkbox checkbox = new Checkbox(string, this.keyGroup, false);
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(checkbox);
        panel.add(new Label(String.valueOf(string2) + "                                 "));
        this.pData.add(panel);
        this.vData.addElement(panel);
        panel.hide();
        this.panels.put(string, panel);
        this.pData.invalidate();
        this.invalidate();
        return checkbox;
    }

    public void updateScrollbar(int n) {
        int n2 = this.vData.size();
        if (n2 <= SHOWING) {
            this.scroll.hide();
            this.invalidate();
            int n3 = 0;
            while (n3 < n2) {
                Panel panel = (Panel)this.vData.elementAt(n3);
                panel.show();
                ++n3;
            }
            this.top = 0;
        } else {
            Panel panel;
            this.scroll.show();
            this.invalidate();
            if (n > n2 - SHOWING) {
                n = n2 - SHOWING;
            }
            this.scroll.setValues(n, SHOWING, 0, n2 - SHOWING);
            int n4 = this.top;
            while (n4 < this.top + SHOWING && n4 < n2) {
                panel = (Panel)this.vData.elementAt(n4);
                panel.hide();
                ++n4;
            }
            n4 = n;
            while (n4 < n + SHOWING) {
                panel = (Panel)this.vData.elementAt(n4);
                panel.show();
                ++n4;
            }
            this.top = n;
            this.pData.invalidate();
        }
        this.validate();
    }
}

