/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import COM.xerox.digipaper.applet.client.LinkRegion;
import COM.xerox.digipaper.applet.editor.EditableAnnotation;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableEntry;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class EditableRegion
extends LinkRegion
implements EditableAnnotation {
    AnnotationTableEntry entry;
    boolean isModified;

    public EditableRegion(AnnotationTableEntry annotationTableEntry) {
        super(annotationTableEntry);
        this.isModified = false;
        this.entry = annotationTableEntry;
    }

    public EditableRegion() {
        super(new Rectangle(), null, 0, true, null, null);
        this.isModified = true;
    }

    public EditableRegion(int n, int n2) {
        super(new Rectangle(n, n2, 0, 0), null, 0, true, null, null);
        this.isModified = true;
    }

    public EditableRegion(Rectangle rectangle, String string, int n, boolean bl, Color color, Color color2) {
        super(rectangle, string, n, bl, color, color2);
        this.isModified = true;
    }

    public EditableRegion(int n, int n2, int n3, int n4, String string, int n5, boolean bl, Color color, Color color2) {
        super(new Rectangle(n, n2, n3, n4), string, n5, bl, color, color2);
        this.isModified = true;
    }

    public byte[] dataToByte() {
        int n;
        String string = this.target;
        int n2 = 1 + string.length();
        if (this.highlight) {
            n2 += 3;
        }
        if (this.displayMode != 5) {
            n2 += 3;
        }
        byte[] byArray = new byte[n2];
        int n3 = 1;
        byArray[0] = (byte)this.displayMode;
        if (this.displayMode != 5) {
            n = this.normColor.getRGB();
            byArray[n3] = (byte)((n & 0xFF0000) >> 16);
            byArray[n3 + 1] = (byte)((n & 0xFF00) >> 8);
            byArray[n3 + 2] = (byte)(n & 0xFF);
            n3 += 3;
        }
        if (this.highlight) {
            byArray[0] = (byte)(this.displayMode + 8);
            n = this.hlColor.getRGB();
            byArray[n3] = (byte)((n & 0xFF0000) >> 16);
            byArray[n3 + 1] = (byte)((n & 0xFF00) >> 8);
            byArray[n3 + 2] = (byte)(n & 0xFF);
            n3 += 3;
        }
        string.getBytes(0, string.length(), byArray, n3);
        return byArray;
    }

    public AnnotationTableEntry toTableEntry(int n, int n2) {
        byte[] byArray = this.dataToByte();
        if (this.isModified || this.entry == null) {
            this.entry = new AnnotationTableEntry(n, 20, this.area.x, this.area.y, this.area.width, this.area.height, byArray.length, n2, byArray);
        }
        return this.entry;
    }

    public boolean inside(int n, int n2) {
        if (this.area == null) {
            return false;
        }
        return this.area.inside(n, n2);
    }

    public void editDraw(Graphics graphics, Color color, float f) {
        Rectangle rectangle = this.scale(f);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public Rectangle editArea() {
        return this.area;
    }

    public AnnotationTableEntry getEntry() {
        return this.entry;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified() {
        this.isModified = true;
    }
}

