/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import COM.xerox.digipaper.applet.client.Anchor;
import COM.xerox.digipaper.applet.editor.EditableAnnotation;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableEntry;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class EditableAnchor
extends Anchor
implements EditableAnnotation {
    public static final int DIAMETER = 20;
    public static final int RADIUS = 10;
    AnnotationTableEntry entry;
    boolean isModified;

    public EditableAnchor(AnnotationTableEntry annotationTableEntry, int n) {
        super(annotationTableEntry, n);
        this.entry = annotationTableEntry;
        this.isModified = false;
    }

    public EditableAnchor(String string, int n, int n2, int n3) {
        this.name = string;
        this.page = n;
        this.x = n2;
        this.y = n3;
        this.isModified = true;
    }

    public AnnotationTableEntry toTableEntry(int n, int n2) {
        byte[] byArray = this.dataToByte();
        if (this.isModified || this.entry == null) {
            this.entry = new AnnotationTableEntry(n, 21, this.x, this.y, 0, 0, byArray.length, n2, byArray);
        }
        return this.entry;
    }

    public byte[] dataToByte() {
        byte[] byArray = new byte[this.name.length()];
        this.name.getBytes(0, byArray.length, byArray, 0);
        return byArray;
    }

    public void editDraw(Graphics graphics, Color color, float f) {
        int n = (int)((float)this.x * f);
        int n2 = (int)((float)this.y * f);
        int n3 = (int)(10.0f * f);
        int n4 = (int)(20.0f * f);
        graphics.setColor(color);
        graphics.drawOval(n - n3, n2 - n3, n4, n4);
        graphics.fillOval(n - 1, n2 - 1, 2, 2);
    }

    public Rectangle editArea() {
        return new Rectangle(this.x - 10, this.y - 10, 20, 20);
    }

    public boolean inside(int n, int n2) {
        int n3 = this.x - n;
        int n4 = this.y - n2;
        return n3 * n3 + n4 * n4 < 100;
    }

    public void setModified() {
        this.isModified = true;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public AnnotationTableEntry getEntry() {
        return this.entry;
    }
}

