/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import COM.xerox.digipaper.applet.client.AnnotMgr;
import COM.xerox.digipaper.applet.client.LinkRegion;
import COM.xerox.digipaper.applet.editor.EditableAnchor;
import COM.xerox.digipaper.applet.editor.EditableAnnotation;
import COM.xerox.digipaper.applet.editor.EditableRegion;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableEntry;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableHeader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;

class EditMgr
extends AnnotMgr {
    public static final int MIN_LINKS = 50;
    public static final int CAP_INC = 20;
    AnnotationTableHeader header;

    public EditMgr(AnnotationTableHeader annotationTableHeader, int n) {
        super(annotationTableHeader, n);
        this.header = annotationTableHeader;
    }

    public void parseHL(AnnotationTableEntry annotationTableEntry) {
        this.links.addElement(new EditableRegion(annotationTableEntry));
    }

    public void parseAnchor(AnnotationTableEntry annotationTableEntry, int n) {
        this.anchors.addElement(new EditableAnchor(annotationTableEntry, n));
    }

    public Enumeration getOtherAnnot() {
        return this.otherAnnot.elements();
    }

    public boolean intersects(Rectangle rectangle) {
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            LinkRegion linkRegion = (LinkRegion)enumeration.nextElement();
            if (linkRegion.area == null || !rectangle.intersects(linkRegion.area)) continue;
            return true;
        }
        return false;
    }

    public boolean anchorExists(int n, int n2) {
        Enumeration enumeration = this.anchors.elements();
        while (enumeration.hasMoreElements()) {
            EditableAnchor editableAnchor = (EditableAnchor)enumeration.nextElement();
            if (editableAnchor.x != n || editableAnchor.y != n2) continue;
            return true;
        }
        return false;
    }

    public EditableAnchor insideAnchor(int n, int n2) {
        Enumeration enumeration = this.anchors.elements();
        while (enumeration.hasMoreElements()) {
            EditableAnchor editableAnchor = (EditableAnchor)enumeration.nextElement();
            int n3 = editableAnchor.x - n;
            int n4 = editableAnchor.y - n2;
            if (n3 * n3 + n4 * n4 >= 100) continue;
            return editableAnchor;
        }
        return null;
    }

    public void add(int n, int n2, int n3, int n4, String string, int n5) {
        this.links.addElement(new EditableRegion(n, n2, n3, n4, string, n5, true, null, null));
    }

    public void add(Rectangle rectangle, String string, int n) {
        this.links.addElement(new EditableRegion(rectangle, string, n, true, null, null));
    }

    public void add(EditableRegion editableRegion) throws IllegalArgumentException {
        if (editableRegion.target == null) {
            throw new IllegalArgumentException("EditableRegion needs target");
        }
        this.links.addElement(editableRegion);
    }

    public void add(EditableAnchor editableAnchor) {
        this.anchors.addElement(editableAnchor);
    }

    public void add(String string, int n, int n2, int n3) {
        this.anchors.addElement(new EditableAnchor(string, n, n2, n3));
    }

    public void updateTable() {
        this.updateTable(this.links.elements());
        this.updateTable(this.anchors.elements());
    }

    public void updateTable(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            EditableAnnotation editableAnnotation = (EditableAnnotation)enumeration.nextElement();
            if (!editableAnnotation.isModified()) continue;
            if (editableAnnotation.getEntry() == null) {
                this.header.table.add(editableAnnotation.toTableEntry(0, 0));
                continue;
            }
            this.header.table.modify(editableAnnotation.getEntry(), editableAnnotation.toTableEntry(0, 0));
        }
    }

    public int linkCount() {
        return this.links.size();
    }

    public void remove(EditableAnnotation editableAnnotation) {
        if (editableAnnotation instanceof EditableRegion) {
            this.links.removeElement(editableAnnotation);
        } else if (editableAnnotation instanceof EditableAnchor) {
            this.anchors.removeElement(editableAnnotation);
        } else {
            this.otherAnnot.removeElement(editableAnnotation);
        }
        if (editableAnnotation.getEntry() != null) {
            this.header.table.remove(editableAnnotation.getEntry());
        }
    }

    public void drawAnchors(Graphics graphics, Color color, float f) {
        this.draw(this.anchors.elements(), graphics, color, f);
    }

    public void drawLinks(Graphics graphics, Color color, float f) {
        this.draw(this.links.elements(), graphics, color, f);
    }

    public void draw(Enumeration enumeration, Graphics graphics, Color color, float f) {
        graphics.setColor(color);
        while (enumeration.hasMoreElements()) {
            EditableAnnotation editableAnnotation = (EditableAnnotation)enumeration.nextElement();
            editableAnnotation.editDraw(graphics, color, f);
        }
    }
}

