/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import COM.xerox.digipaper.applet.client.Client;
import COM.xerox.digipaper.applet.editor.ClientSelectRegionCanvas;
import COM.xerox.digipaper.applet.editor.ColorButton;
import COM.xerox.digipaper.applet.editor.EditableAnchor;
import COM.xerox.digipaper.applet.editor.EditableAnnotation;
import COM.xerox.digipaper.applet.editor.EditableRegion;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

class EditCommandBar
extends Panel {
    Client viewer;
    ClientSelectRegionCanvas imageCanvas;
    int curPageNo;
    Choice editMode;
    CardLayout clEdit;
    Panel pEdit;
    Panel pNormal;
    Panel pLink;
    Panel pAnchor;
    TextField targetURL;
    Button submitLink;
    Button deleteLink;
    Choice linkDisplayMode;
    Checkbox highlight;
    ColorButton cbNormal;
    ColorButton cbHighlight;
    TextField tfAnchorName;
    Button bSubmitAnchor;
    Button bDeleteAnchor;
    Button bGotoAnchor;

    public EditCommandBar(Client client) {
        this.viewer = client;
        this.imageCanvas = (ClientSelectRegionCanvas)client.imageCanvas;
        this.init();
    }

    public void init() {
        this.pLink = new Panel();
        this.targetURL = new TextField("http://", 50);
        this.submitLink = new Button("add/change");
        this.deleteLink = new Button("delete");
        this.highlight = new Checkbox("Highlight");
        this.targetURL.setEditable(true);
        this.linkDisplayMode = new Choice();
        this.linkDisplayMode.addItem("Outline");
        this.linkDisplayMode.addItem("Top");
        this.linkDisplayMode.addItem("Left");
        this.linkDisplayMode.addItem("Right");
        this.linkDisplayMode.addItem("Bottom");
        this.linkDisplayMode.addItem("None");
        this.cbNormal = new ColorButton((Frame)this.viewer.window, "Color", Color.blue);
        this.cbHighlight = new ColorButton((Frame)this.viewer.window, "Highlight", Color.red);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 0, 2, 1));
        panel.add(this.submitLink);
        panel.add(this.deleteLink);
        panel.add(this.linkDisplayMode);
        panel.add(this.cbNormal);
        panel.add(this.highlight);
        panel.add(this.cbHighlight);
        this.pLink.setLayout(new BorderLayout());
        this.pLink.add("West", new Label("Link URL:"));
        this.pLink.add("Center", this.targetURL);
        this.pLink.add("North", panel);
        this.pAnchor = new Panel();
        this.tfAnchorName = new TextField(15);
        this.pAnchor.add(this.tfAnchorName);
        this.bDeleteAnchor = new Button("Delete");
        this.pAnchor.add(this.bDeleteAnchor);
        this.bSubmitAnchor = new Button("Add/Change");
        this.pAnchor.add(this.bSubmitAnchor);
        this.bGotoAnchor = new Button("Locate");
        this.pAnchor.add(this.bGotoAnchor);
        this.pNormal = new Panel();
        this.pNormal.add(new Label("DigiPaper Editor: Xerox PARC and Cornell University"));
        this.clEdit = new CardLayout();
        this.pEdit = new Panel();
        this.pEdit.setLayout(this.clEdit);
        this.pEdit.add("None", this.pNormal);
        this.pEdit.add("Hyperlinks", this.pLink);
        this.pEdit.add("Anchors", this.pAnchor);
        this.editMode = new Choice();
        this.editMode.addItem("None");
        this.editMode.addItem("Hyperlinks");
        this.editMode.addItem("Anchors");
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("North", new Label("Edit Mode:"));
        panel2.add("South", this.editMode);
        this.setLayout(new BorderLayout());
        this.add("West", panel2);
        this.add("Center", this.pEdit);
        this.doEdit();
    }

    public boolean handleEvent(Event event) {
        String string = this.editMode.getSelectedItem();
        if (string == "Hyperlinks") {
            this.viewer.printMessage("");
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.editMode) {
            this.doEdit((String)object);
            return true;
        }
        if (this.imageCanvas.image == null) {
            this.viewer.printMessage("No document loaded.");
            return false;
        }
        String string = this.editMode.getSelectedItem();
        if (string == "Anchors") {
            return this.anchorAction(event, object);
        }
        if (string == "Hyperlinks") {
            return this.linkAction(event, object);
        }
        return false;
    }

    public boolean anchorAction(Event event, Object object) {
        if (event.target == this.bGotoAnchor) {
            this.doGotoAnchor();
        } else if (event.target == this.bSubmitAnchor || event.target == this.tfAnchorName) {
            this.doSubmitAnchor();
        } else if (event.target == this.bDeleteAnchor) {
            this.doDeleteAnchor();
        } else {
            return false;
        }
        return true;
    }

    public void doGotoAnchor() {
        String string = this.tfAnchorName.getText();
        if (string != null) {
            this.imageCanvas.DoShowDocument("#" + string);
        }
    }

    public void doSubmitAnchor() {
        String string = this.tfAnchorName.getText();
        if (string == "") {
            this.viewer.printMessage("Please enter a name for the anchor");
            return;
        }
        if (this.imageCanvas.addSelected(string)) {
            this.viewer.printMessage("Anchor <" + string + "> added successfully");
        }
    }

    public void doDeleteAnchor() {
        if (this.imageCanvas.deleteSelected()) {
            ((TextComponent)this.tfAnchorName).setText(this.imageCanvas.curText);
            this.viewer.printMessage("Anchor removed successfully.");
            return;
        }
        this.viewer.printMessage("No Anchor to remove!");
    }

    public boolean linkAction(Event event, Object object) {
        if (event.target == this.highlight) {
            if (this.highlight.getState()) {
                this.cbHighlight.enable();
            } else {
                this.cbHighlight.disable();
            }
            this.cbHighlight.repaint();
            this.doSubmitLink();
        } else if (event.target == this.linkDisplayMode) {
            if (this.getDispMode() == 5) {
                this.cbNormal.disable();
            } else {
                this.cbNormal.enable();
            }
            this.cbNormal.repaint();
            this.doSubmitLink();
        } else if (event.target == this.submitLink || event.target == this.targetURL || event.target == this.cbNormal || event.target == this.cbHighlight) {
            this.doSubmitLink();
        } else if (event.target == this.deleteLink) {
            this.doDeleteLink();
        } else {
            return false;
        }
        return true;
    }

    public void ToggleEdit(boolean bl) {
        if (bl) {
            this.doEdit();
            return;
        }
        this.imageCanvas.ToggleEdit("None");
    }

    public void doEdit() {
        this.doEdit(this.editMode.getSelectedItem());
    }

    public void doEdit(String string) {
        this.imageCanvas.ToggleEdit(string);
        this.clEdit.show(this.pEdit, string);
        this.pEdit.invalidate();
        this.validate();
        if (this.viewer.curFile != null) {
            this.submitLink.enable();
            this.deleteLink.enable();
            this.linkDisplayMode.enable();
            this.targetURL.enable();
            this.highlight.enable();
            if (this.getDispMode() != 5) {
                this.cbNormal.enable();
            } else {
                this.cbNormal.disable();
            }
            this.cbNormal.repaint();
            if (this.highlight.getState()) {
                this.cbHighlight.enable();
            } else {
                this.cbHighlight.disable();
            }
            this.cbHighlight.repaint();
            this.tfAnchorName.enable();
            this.bGotoAnchor.enable();
            this.bDeleteAnchor.enable();
            this.bSubmitAnchor.enable();
            return;
        }
        this.submitLink.disable();
        this.deleteLink.disable();
        this.linkDisplayMode.disable();
        this.targetURL.disable();
        this.highlight.disable();
        this.cbNormal.disable();
        this.cbHighlight.disable();
        this.tfAnchorName.disable();
        this.bGotoAnchor.disable();
        this.bDeleteAnchor.disable();
        this.bSubmitAnchor.disable();
    }

    public void doSubmitLink() {
        if (this.targetURL.getText() == null) {
            this.viewer.printMessage("Please enter the URL into the text field.");
            return;
        }
        if (!this.imageCanvas.regionAvailable()) {
            this.viewer.printMessage("Please select a region first.");
            return;
        }
        if (this.imageCanvas.addSelected(this.targetURL.getText(), this.getDispMode(), this.highlight.getState(), this.cbNormal.color, this.cbHighlight.color)) {
            this.viewer.printMessage("New Hyperlink added successfully.");
            return;
        }
        this.viewer.printMessage("Please enter a valid URL.");
    }

    public void updateSelected(EditableAnnotation editableAnnotation) {
        if (editableAnnotation instanceof EditableRegion) {
            EditableRegion editableRegion = (EditableRegion)editableAnnotation;
            this.linkDisplayMode.select(editableRegion.displayMode);
            ((TextComponent)this.targetURL).setText(editableRegion.target.toString());
            this.highlight.setState(editableRegion.highlight);
            if (editableRegion.displayMode != 5) {
                this.cbNormal.enable();
                this.cbNormal.setColor(editableRegion.normColor);
            } else {
                this.cbNormal.disable();
            }
            if (editableRegion.highlight) {
                this.cbHighlight.enable();
                this.cbHighlight.setColor(editableRegion.hlColor);
            } else {
                this.cbHighlight.disable();
            }
            this.cbNormal.repaint();
            this.cbHighlight.repaint();
            return;
        }
        if (editableAnnotation instanceof EditableAnchor) {
            EditableAnchor editableAnchor = (EditableAnchor)editableAnnotation;
            ((TextComponent)this.tfAnchorName).setText(editableAnchor.name);
        }
    }

    public int getDispMode() {
        return this.linkDisplayMode.getSelectedIndex();
    }

    public void doDeleteLink() {
        if (this.imageCanvas.deleteSelected()) {
            ((TextComponent)this.targetURL).setText(this.imageCanvas.curText);
            this.viewer.printMessage("Hyperlink removed successfully.");
            return;
        }
        this.viewer.printMessage("No Hyperlink to remove!");
    }

    public void updateTarget(String string) {
        ((TextComponent)this.targetURL).setText(string);
    }
}

