/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import COM.xerox.digipaper.applet.client.DocInfoWindow;
import COM.xerox.digipaper.applet.editor.HashGUI;
import COM.xerox.digipaper.applet.editor.LinkEditor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.Hashtable;

public class EditAuthorDialog
extends Dialog {
    static String KEY_AUTHOR = new String("Author");
    static String KEY_TITLE = new String("Title");
    static String KEY_DATE = new String("Date");
    static String KEY_NOTES = new String("Notes");
    static String KEY_OTHER = new String("Other...");
    LinkEditor viewer;
    public HashGUI table;
    public boolean isOk = false;
    TextField tKey;
    TextField tValue;
    Choice cKeys;
    CardLayout keyLayout;
    Panel pKey;
    Button bDelete;
    Button bApply;
    Button bTest;
    Button bOk;
    Button bCancel;

    public void closeWindow() {
        this.tKey = null;
        this.tValue = null;
        this.cKeys = null;
        this.pKey = null;
        this.bDelete = null;
        this.bApply = null;
        this.dispose();
        ((Component)this).hide();
    }

    public EditAuthorDialog(LinkEditor linkEditor, Hashtable hashtable) {
        super(linkEditor.frame, "Document Information", true);
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.table = new HashGUI(hashtable);
        this.viewer = linkEditor;
        this.tKey = new TextField(10);
        this.tValue = new TextField(20);
        this.cKeys = new Choice();
        this.cKeys.addItem(KEY_AUTHOR);
        this.cKeys.addItem(KEY_TITLE);
        this.cKeys.addItem(KEY_DATE);
        this.cKeys.addItem(KEY_NOTES);
        this.cKeys.addItem(KEY_OTHER);
        this.keyLayout = new CardLayout();
        this.pKey = new Panel();
        this.pKey.setLayout(this.keyLayout);
        this.pKey.add(KEY_AUTHOR, new Label(KEY_AUTHOR));
        this.pKey.add(KEY_TITLE, new Label(KEY_TITLE));
        this.pKey.add(KEY_DATE, new Label(KEY_DATE));
        this.pKey.add(KEY_NOTES, new Label(KEY_NOTES));
        this.pKey.add(KEY_OTHER, this.tKey);
        this.bDelete = new Button("Delete");
        this.bApply = new Button("Apply");
        this.bTest = new Button("Test");
        this.bOk = new Button(" Ok ");
        this.bCancel = new Button("Cancel");
        Panel panel = new Panel();
        panel.add(this.cKeys);
        panel.add(this.pKey);
        panel.add(this.tValue);
        Panel panel2 = new Panel();
        panel2.add(this.bDelete);
        panel2.add(this.bApply);
        panel2.add(this.bTest);
        panel2.add(this.bOk);
        panel2.add(this.bCancel);
        this.setLayout(new BorderLayout());
        this.add("Center", this.table);
        this.add("North", panel);
        this.add("South", panel2);
        this.verify();
        this.pack();
        this.setResizable(false);
        this.validate();
    }

    public void verify() {
        if (this.table.current() == HashGUI.NEW_KEY) {
            this.bDelete.disable();
        } else {
            this.bDelete.enable();
            ((TextComponent)this.tKey).setText(this.table.current());
            this.tKey.selectAll();
            ((TextComponent)this.tValue).setText(this.table.value());
            this.tValue.selectAll();
        }
        this.cKeys.select(KEY_OTHER);
        this.keyLayout.show(this.pKey, KEY_OTHER);
    }

    public void doChoiceKey() {
        this.keyLayout.show(this.pKey, this.cKeys.getSelectedItem());
    }

    public void doApply() {
        String string = this.cKeys.getSelectedItem();
        if (string == KEY_OTHER) {
            string = this.tKey.getText();
        }
        this.table.add(string, this.tValue.getText());
        this.validate();
        this.verify();
    }

    public void doDelete() {
        this.table.remove();
        this.validate();
    }

    public void doTest() {
        DocInfoWindow docInfoWindow = new DocInfoWindow(this.table.table);
        docInfoWindow.init();
        docInfoWindow.show();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.bApply) {
            this.doApply();
        } else if (event.target == this.bDelete) {
            this.doDelete();
        } else if (event.target == this.cKeys) {
            this.doChoiceKey();
        } else if (event.target == this.table) {
            this.verify();
        } else if (event.target == this.bTest) {
            this.doTest();
        } else if (event.target == this.bOk) {
            this.isOk = true;
            this.closeWindow();
        } else if (event.target == this.bCancel) {
            this.closeWindow();
        } else {
            return false;
        }
        return true;
    }
}

