/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import COM.xerox.digipaper.applet.editor.ColorPalette;
import COM.xerox.digipaper.applet.editor.Colorbox;
import COM.xerox.digipaper.applet.editor.NumberField;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class ColorWindow
extends Dialog {
    ColorPalette palette = new ColorPalette();
    Colorbox current;
    Button bOk;
    Button bCancel;
    NumberField red;
    NumberField green;
    NumberField blue;

    public Color color() {
        return this.current.color;
    }

    public ColorWindow(Frame frame, String string, Color color) {
        super(frame, string, true);
        this.current = new Colorbox(color);
        this.red = new NumberField(0, 255, 3, color.getRed());
        this.green = new NumberField(0, 255, 3, color.getGreen());
        this.blue = new NumberField(0, 255, 3, color.getBlue());
        this.bOk = new Button("  Ok  ");
        this.bCancel = new Button("Cancel");
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        panel.add(this.bOk);
        panel.add(this.bCancel);
        panel2.setLayout(new GridLayout(3, 2));
        panel2.add(new Label("Red: "));
        panel2.add(this.red);
        panel2.add(new Label("Green: "));
        panel2.add(this.green);
        panel2.add(new Label("Blue: "));
        panel2.add(this.blue);
        panel3.setLayout(new GridLayout(1, 2, 10, 10));
        panel3.add(panel2);
        panel3.add(this.current);
        panel4.setLayout(new BorderLayout());
        panel4.add("Center", panel3);
        panel4.add("South", panel);
        this.setLayout(new BorderLayout());
        this.add("Center", this.palette);
        this.add("South", panel4);
        this.resize(250, 300);
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.palette.current && this.palette.color != null && event.id == 501) {
            this.setColor(this.palette.color);
        } else if (event.id == 201) {
            this.doCancel();
        } else if (event.target == this.red || event.target == this.green || event.target == this.blue) {
            this.setColor(new Color(this.red.value, this.green.value, this.blue.value));
        } else if (event.id == 1001) {
            return this.action(event);
        }
        return true;
    }

    public boolean action(Event event) {
        if (event.target == this.bCancel) {
            this.doCancel();
        } else if (event.target == this.bOk) {
            this.doOk();
        }
        return true;
    }

    public void setColor(Color color) {
        this.palette.color = color;
        this.current.color = color;
        this.red.setText(color.getRed());
        this.green.setText(color.getGreen());
        this.blue.setText(color.getBlue());
        this.palette.repaint();
        this.current.repaint();
    }

    public void doCancel() {
        this.current.color = null;
        ((Component)this).hide();
    }

    public void doOk() {
        ((Component)this).hide();
    }

    public void CloseWindow() {
        this.palette = null;
        this.current = null;
        this.red = null;
        this.green = null;
        this.blue = null;
        this.bOk = null;
        this.bCancel = null;
        this.dispose();
        ((Component)this).hide();
    }
}

