/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import COM.xerox.digipaper.applet.editor.ColorWindow;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;

public class ColorButton
extends Canvas {
    static int MARGIN = 5;
    String name;
    Color color;
    ColorWindow window;
    boolean isDown;
    boolean buttonDown;
    Dimension minSize;
    Frame parent;
    String title;

    public ColorButton(Frame frame, String string, Color color) {
        this.name = String.valueOf(string) + "...";
        this.color = color;
        this.parent = frame;
        this.title = "ColorWindow: " + string;
        this.isDown = false;
        this.buttonDown = false;
        this.minSize = new Dimension(string.length() * 8 + 20 + MARGIN * 2, 20);
        this.show();
    }

    public void createWindow() {
        if (this.window != null) {
            this.window.CloseWindow();
        }
        this.window = new ColorWindow(this.parent, this.title, this.color);
    }

    public void finalize() {
        if (this.window != null) {
            this.window.CloseWindow();
        }
    }

    public Dimension minimumSize() {
        return this.minSize;
    }

    public Dimension preferredSize() {
        return this.minSize;
    }

    public boolean handleEvent(Event event) {
        if (this.isEnabled()) {
            return super.handleEvent(event);
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.isDown = true;
        this.buttonDown = true;
        this.repaint();
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.isDown) {
            this.isDown = false;
            this.repaint();
        }
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        if (this.buttonDown) {
            this.isDown = true;
            this.repaint();
        }
        return true;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.buttonDown = false;
        if (this.isDown) {
            this.isDown = false;
            this.repaint();
            this.createWindow();
            ((Window)this.window).show();
            if (this.window.color() != null) {
                this.color = this.window.color();
                this.repaint();
                return this.postEvent(new Event(this, 1001, this.color));
            }
        }
        return true;
    }

    public void paint(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.isDown) {
            graphics.setColor(new Color(160, 160, 160));
        } else {
            graphics.setColor(Color.lightGray);
        }
        graphics.fillRect(0, 0, n, n2);
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.gray);
        }
        graphics.drawString(this.name, MARGIN, n2 / 2 + 4);
        graphics.setColor(this.color);
        graphics.fillRect(n - 20, MARGIN, 15, n2 - MARGIN * 2);
        graphics.setColor(Color.black);
        graphics.drawRect(n - 20, MARGIN, 15, n2 - MARGIN * 2);
        if (this.isDown) {
            graphics.setColor(Color.gray);
        } else {
            graphics.setColor(new Color(234, 234, 234));
        }
        graphics.fillRect(0, 0, n, 2);
        graphics.fillRect(0, 0, 2, n2);
        if (this.isDown) {
            graphics.setColor(new Color(234, 234, 234));
        } else {
            graphics.setColor(Color.gray);
        }
        graphics.fillRect(1, n2 - 1, n, 1);
        graphics.fillRect(2, n2 - 2, n - 1, 1);
        graphics.fillRect(n - 2, 2, 1, n2);
        graphics.fillRect(n - 1, 1, 1, n2);
    }
}

