/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.editor;

import COM.xerox.digipaper.applet.client.AnnotMgr;
import COM.xerox.digipaper.applet.client.Client;
import COM.xerox.digipaper.applet.client.ClientCanvas;
import COM.xerox.digipaper.applet.editor.EditMgr;
import COM.xerox.digipaper.applet.editor.EditableAnchor;
import COM.xerox.digipaper.applet.editor.EditableAnnotation;
import COM.xerox.digipaper.applet.editor.EditableRegion;
import COM.xerox.digipaper.applet.editor.LinkEditor;
import COM.xerox.digipaper.applet.xiff.SaveToFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableHeader;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class ClientSelectRegionCanvas
extends ClientCanvas {
    public static final String EM_NORMAL = "None";
    public static final String EM_LINK = "Hyperlinks";
    public static final String EM_ANCHOR = "Anchors";
    public static final int MARGIN = 3;
    static final Color SELECT = Color.red;
    static final Color EXISTING = Color.lightGray;
    static final Color BACKGROUND = Color.white;
    public EditableAnnotation selected;
    public String curText;
    public boolean textUpdated;
    private String editMode = "None";
    int prevx;
    int prevy;
    int cursor;

    public ClientSelectRegionCanvas(Client client) {
        super(client);
    }

    public void ToggleEdit(String string) {
        if (string == this.editMode) {
            return;
        }
        if (string.equals(EM_NORMAL)) {
            this.enableView();
        } else {
            this.disableView();
        }
        if (this.editMode.equals(EM_ANCHOR)) {
            this.anchor = null;
        }
        this.editMode = string;
        this.selected = null;
        this.repaint();
    }

    public void saveAnnots(SaveToFile saveToFile) throws IOException {
        System.out.println("Modifying copied file " + this.numOfPages);
        int n = 0;
        while (n < this.numOfPages) {
            System.out.print(String.valueOf(this.numOfPages - n) + " ");
            if (this.AnnotBuffer[n] != null) {
                ((EditMgr)this.AnnotBuffer[n]).updateTable();
                saveToFile.write(((EditMgr)this.AnnotBuffer[n]).header);
            }
            ++n;
        }
    }

    public SaveToFile getSaveTarget(String string) throws IOException {
        File file = new File(string);
        if (!(!file.exists() || file.canRead() && file.canWrite())) {
            this.viewer.printMessage(String.valueOf(string) + "cannot be overwritten");
            throw new IOException(String.valueOf(string) + "cannot be overwritten");
        }
        SaveToFile saveToFile = new SaveToFile(string, this.viewer.curFile);
        return saveToFile;
    }

    public void saveFile(String string, Hashtable hashtable) throws IOException {
        SaveToFile saveToFile = this.getSaveTarget(string);
        saveToFile.write(hashtable);
        this.saveAnnots(saveToFile);
        saveToFile.commit();
    }

    public void saveFile(String string) throws IOException {
        SaveToFile saveToFile = this.getSaveTarget(string);
        this.saveAnnots(saveToFile);
        saveToFile.commit();
    }

    public void newPage() {
        if (this.annotations != null) {
            this.getMgr().updateTable();
        }
        ((LinkEditor)this.viewer).commandBar.disableEdit();
        super.newPage();
        this.selected = null;
    }

    public boolean getAnnotations(int n) {
        if (super.getAnnotations(n)) {
            if (this.renderThread.page_descriptor.annot_hdr.isValid) {
                ((LinkEditor)this.viewer).commandBar.enableEdit();
            } else {
                this.viewer.printMessage("Annotations for this page not writable");
            }
            return true;
        }
        return false;
    }

    protected AnnotMgr newMgr(AnnotationTableHeader annotationTableHeader, int n) {
        return new EditMgr(annotationTableHeader, n);
    }

    private EditMgr getMgr() {
        return (EditMgr)this.annotations;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.image == null) {
            return false;
        }
        if (this.editMode.equals(EM_NORMAL)) {
            return super.mouseDown(event, n, n2);
        }
        this.prevx = this.normalize(n + this.dx);
        this.prevy = this.normalize(n2 + this.dy);
        if (this.selected != null) {
            if (this.selected.inside(this.prevx, this.prevy)) {
                return true;
            }
            if (this.selected instanceof EditableRegion && (ClientSelectRegionCanvas.topBorder(this.prevx, this.prevy, ((EditableRegion)this.selected).area) || ClientSelectRegionCanvas.bottomBorder(this.prevx, this.prevy, ((EditableRegion)this.selected).area) || ClientSelectRegionCanvas.leftBorder(this.prevx, this.prevy, ((EditableRegion)this.selected).area) || ClientSelectRegionCanvas.rightBorder(this.prevx, this.prevy, ((EditableRegion)this.selected).area))) {
                return true;
            }
            EditableAnnotation editableAnnotation = this.selected;
            this.selected = null;
            this.repaint(editableAnnotation.editArea());
            this.viewer.setCursor(0);
        }
        if (this.editMode.equals(EM_LINK)) {
            if (this.current == null) {
                this.selected = new EditableRegion(this.prevx, this.prevy);
            } else {
                this.selected = (EditableRegion)this.current;
                this.curText = this.current.target;
                this.repaint(this.current.area);
                ((LinkEditor)this.viewer).commandBar.pEdit.updateSelected(this.selected);
            }
        } else if (this.editMode.equals(EM_ANCHOR)) {
            if (this.anchor == null) {
                this.selected = new EditableAnchor(null, this.curPageNo, this.prevx, this.prevy);
            } else {
                this.selected = (EditableAnchor)this.anchor;
                this.curText = this.anchor.name;
                ((LinkEditor)this.viewer).commandBar.pEdit.updateSelected(this.selected);
            }
            this.viewer.setCursor(13);
            this.repaint(this.selected.editArea());
        }
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.image == null || this.annotations == null) {
            return false;
        }
        if (this.editMode.equals(EM_NORMAL)) {
            return super.mouseMove(event, n, n2);
        }
        int n3 = this.normalize(n + this.dx);
        int n4 = this.normalize(n2 + this.dy);
        if (this.current != null && !this.current.area.inside(n3, n4)) {
            this.current = null;
            this.viewer.printMessage("");
        }
        if (this.current == null) {
            this.current = this.annotations.insideHL(n3, n4);
            if (this.current != null) {
                this.viewer.printMessage(this.current.target);
            }
        }
        if (this.editMode.equals(EM_ANCHOR)) {
            if (this.anchor != null && ((EditableAnchor)this.anchor).inside(n3, n4)) {
                return true;
            }
            this.anchor = this.getMgr().insideAnchor(n3, n4);
            if (this.anchor == null) {
                this.viewer.printMessage("x:" + n3 + " y:" + n4);
            } else {
                this.viewer.printMessage(this.anchor.name);
            }
        }
        if (this.selected == null) {
            return true;
        }
        if (this.selected instanceof EditableRegion) {
            if (((EditableRegion)this.selected).target == null) {
                this.viewer.setCursor(0);
                this.cursor = 0;
                return true;
            }
            if (ClientSelectRegionCanvas.topBorder(n3, n4, ((EditableRegion)this.selected).area)) {
                if (ClientSelectRegionCanvas.leftBorder(n3, n4, ((EditableRegion)this.selected).area)) {
                    this.viewer.setCursor(6);
                    this.cursor = 6;
                } else if (ClientSelectRegionCanvas.rightBorder(n3, n4, ((EditableRegion)this.selected).area)) {
                    this.viewer.setCursor(7);
                    this.cursor = 7;
                } else {
                    this.viewer.setCursor(8);
                    this.cursor = 8;
                }
            } else if (ClientSelectRegionCanvas.bottomBorder(n3, n4, ((EditableRegion)this.selected).area)) {
                if (ClientSelectRegionCanvas.leftBorder(n3, n4, ((EditableRegion)this.selected).area)) {
                    this.viewer.setCursor(4);
                    this.cursor = 4;
                } else if (ClientSelectRegionCanvas.rightBorder(n3, n4, ((EditableRegion)this.selected).area)) {
                    this.viewer.setCursor(5);
                    this.cursor = 5;
                } else {
                    this.viewer.setCursor(9);
                    this.cursor = 9;
                }
            } else if (ClientSelectRegionCanvas.leftBorder(n3, n4, ((EditableRegion)this.selected).area)) {
                this.viewer.setCursor(10);
                this.cursor = 10;
            } else if (ClientSelectRegionCanvas.rightBorder(n3, n4, ((EditableRegion)this.selected).area)) {
                this.viewer.setCursor(11);
                this.cursor = 11;
            } else if (this.selected.inside(n3, n4)) {
                this.viewer.setCursor(13);
                this.cursor = 13;
            } else {
                this.viewer.setCursor(0);
                this.cursor = 0;
            }
        } else if (this.selected.inside(n3, n4)) {
            this.viewer.setCursor(13);
            this.cursor = 13;
        } else {
            this.viewer.setCursor(0);
            this.cursor = 0;
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.image == null) {
            return false;
        }
        if (this.editMode.equals(EM_NORMAL)) {
            return super.mouseDrag(event, n, n2);
        }
        if (this.selected == null) {
            return false;
        }
        int n3 = this.normalize(n + this.dx);
        int n4 = this.normalize(n2 + this.dy);
        if (this.editMode.equals(EM_LINK)) {
            return this.dragLink(n3, n4);
        }
        if (this.editMode.equals(EM_ANCHOR)) {
            return this.dragAnchor(n3, n4);
        }
        return false;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public boolean dragLink(int var1_1, int var2_2) {
        var3_3 = (EditableRegion)this.selected;
        var4_4 = var3_3.area.x;
        var5_5 = var3_3.area.y;
        var6_6 = var1_1;
        if (var6_6 >= this.iWidth) {
            var6_6 = this.iWidth - 1;
        } else if (var6_6 < 0) {
            var6_6 = 0;
        }
        var7_7 = var2_2;
        if (var7_7 >= this.iHeight) {
            var7_7 = this.iHeight - 1;
        } else if (var7_7 < 0) {
            var7_7 = 0;
        }
        var10_8 = new Rectangle();
        if (var3_3.target == null) ** GOTO lbl67
        var10_8.reshape(var3_3.area.x, var3_3.area.y, var3_3.area.width, var3_3.area.height);
        switch (this.cursor) {
            case 4: 
            case 6: 
            case 10: {
                if (var10_8.width + var4_4 - var6_6 > 0) {
                    var10_8.width += var4_4 - var6_6;
                    var10_8.x = var6_6;
                    break;
                }
                var10_8.x = var10_8.width + var4_4 - 1;
                var10_8.width = 1;
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                if (var6_6 - var4_4 > 0) {
                    var10_8.width = var6_6 - var4_4;
                    break;
                }
                var10_8.width = 1;
                break;
            }
        }
        switch (this.cursor) {
            case 6: 
            case 7: 
            case 8: {
                if (var10_8.height + var5_5 - var7_7 > 0) {
                    var10_8.height += var5_5 - var7_7;
                    var10_8.y = var7_7;
                    break;
                }
                var10_8.y = var10_8.height + var5_5 - 1;
                var10_8.height = 1;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                if (var7_7 - var5_5 > 0) {
                    var10_8.height = var7_7 - var5_5;
                    break;
                }
                var10_8.height = 1;
                break;
            }
        }
        switch (this.cursor) {
            case 10: 
            case 11: {
                this.prevx = var6_6;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.prevx = var6_6;
            }
            case 8: 
            case 9: {
                this.prevy = var7_7;
                break;
            }
            case 13: {
                var11_9 = var6_6 - this.prevx;
                var12_12 = var7_7 - this.prevy;
                if (var10_8.x + var10_8.width + var11_9 > this.iWidth || var10_8.x + var11_9 < 0) {
                    var11_9 = 0;
                }
                if (var10_8.y + var10_8.height + var12_12 > this.iHeight || var10_8.y + var12_12 < 0) {
                    var12_12 = 0;
                }
                var10_8.translate(var11_9, var12_12);
                break;
            }
lbl67:
            // 1 sources

            var11_10 = (EditableRegion)this.getMgr().insideHL(var4_4, var7_7);
            if (var11_10 != null) {
                var7_7 = this.prevy;
            }
            if ((var11_10 = (EditableRegion)this.getMgr().insideHL(var6_6, var5_5)) != null) {
                var6_6 = this.prevx;
            }
            var8_13 = var6_6 - var4_4;
            var9_14 = var7_7 - var5_5;
            var10_8.reshape(var4_4, var5_5, var8_13, var9_14);
            break;
        }
        var11_11 = var3_3.area;
        var3_3.area = null;
        if (!this.getMgr().intersects(this.makeDrawable(var10_8))) {
            this.prevx = var6_6;
            this.prevy = var7_7;
            this.repaint(this.makeDrawable(var11_11));
            var3_3.area = var10_8;
            this.selected.setModified();
            ((LinkEditor)this.viewer).commandBar.setModified();
            this.repaint(this.makeDrawable(var10_8));
            return true;
        }
        var3_3.area = var11_11;
        return false;
    }

    public static boolean leftBorder(int n, int n2, Rectangle rectangle) {
        if (n2 > rectangle.y - 3 && n2 <= rectangle.y + rectangle.height + 3) {
            return n < rectangle.x + 3 && n > rectangle.x - 3;
        }
        return false;
    }

    public static boolean rightBorder(int n, int n2, Rectangle rectangle) {
        if (n2 > rectangle.y - 3 && n2 <= rectangle.y + rectangle.height + 3) {
            return n <= rectangle.x + rectangle.width + 3 && n >= rectangle.x + rectangle.width - 3;
        }
        return false;
    }

    public static boolean topBorder(int n, int n2, Rectangle rectangle) {
        if (n > rectangle.x - 3 && n <= rectangle.x + rectangle.width + 3) {
            return n2 < rectangle.y + 3 && n2 > rectangle.y - 3;
        }
        return false;
    }

    public static boolean bottomBorder(int n, int n2, Rectangle rectangle) {
        if (n > rectangle.x - 3 && n <= rectangle.x + rectangle.width + 3) {
            return n2 < rectangle.y + rectangle.height + 3 - 1 && n2 > rectangle.y + rectangle.height - 3 - 1;
        }
        return false;
    }

    public boolean dragAnchor(int n, int n2) {
        EditableAnchor editableAnchor = (EditableAnchor)this.selected;
        int n3 = editableAnchor.x + n - this.prevx;
        int n4 = editableAnchor.y + n2 - this.prevy;
        if (n3 >= this.iWidth || n3 < 0) {
            n3 = editableAnchor.x;
        }
        if (n4 >= this.iHeight || n4 < 0) {
            n4 = editableAnchor.y;
        }
        if (!this.getMgr().anchorExists(n3, n4)) {
            this.selected = null;
            this.repaint(editableAnchor.editArea());
            editableAnchor.setModified();
            editableAnchor.x = n3;
            editableAnchor.y = n4;
            this.selected = editableAnchor;
            this.repaint(this.selected.editArea());
            this.prevx = n;
            this.prevy = n2;
            return true;
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.image == null) {
            return false;
        }
        if (this.editMode.equals(EM_NORMAL)) {
            return super.mouseUp(event, n, n2);
        }
        if (this.editMode.equals(EM_LINK) && this.selected != null) {
            ((EditableRegion)this.selected).area = this.makeDrawable(((EditableRegion)this.selected).area);
            ((LinkEditor)this.viewer).commandBar.pEdit.targetURL.requestFocus();
            ((LinkEditor)this.viewer).commandBar.pEdit.targetURL.selectAll();
        }
        if (this.editMode.equals(EM_ANCHOR)) {
            ((LinkEditor)this.viewer).commandBar.pEdit.tfAnchorName.requestFocus();
            ((LinkEditor)this.viewer).commandBar.pEdit.tfAnchorName.selectAll();
        }
        return true;
    }

    public boolean regionAvailable() {
        return this.selected != null && !((EditableRegion)this.selected).area.isEmpty();
    }

    public boolean addSelected(String string) {
        if (this.selected == null) {
            this.viewer.printMessage("Please select a point first.");
            return false;
        }
        EditableAnchor editableAnchor = (EditableAnchor)this.anchors.get(string);
        if (editableAnchor != null) {
            this.viewer.printMessage("Name already in use.<" + string + ", " + editableAnchor.page + ", (" + editableAnchor.x + "," + editableAnchor.y + ")>");
            return false;
        }
        ((LinkEditor)this.viewer).commandBar.setModified();
        editableAnchor = (EditableAnchor)this.selected;
        if (editableAnchor.name != null) {
            this.anchors.remove(editableAnchor.name);
        } else {
            this.getMgr().add(editableAnchor);
        }
        editableAnchor.name = string;
        editableAnchor.setModified();
        this.anchors.put(string, editableAnchor);
        return true;
    }

    public boolean addSelected(String string, int n, boolean bl, Color color, Color color2) {
        if (!this.regionAvailable()) {
            return false;
        }
        ((LinkEditor)this.viewer).commandBar.setModified();
        EditableRegion editableRegion = (EditableRegion)this.selected;
        if (editableRegion.target == null) {
            editableRegion = new EditableRegion(editableRegion.area, string, n, bl, color, color2);
            this.getMgr().add(editableRegion);
            this.selected = editableRegion;
        } else {
            editableRegion.target = string;
            editableRegion.displayMode = n;
            editableRegion.highlight = bl;
            editableRegion.normColor = color;
            editableRegion.hlColor = color2;
            editableRegion.setModified();
        }
        return true;
    }

    public boolean deleteSelected() {
        if (this.selected == null) {
            return false;
        }
        if (this.selected instanceof EditableRegion) {
            EditableRegion editableRegion = (EditableRegion)this.selected;
            if (editableRegion.target == null) {
                return false;
            }
            ((LinkEditor)this.viewer).commandBar.setModified();
            this.getMgr().remove(editableRegion);
            this.curText = editableRegion.target;
            this.selected = null;
            this.repaint(editableRegion.area);
            return true;
        }
        if (this.selected instanceof EditableAnchor) {
            EditableAnchor editableAnchor = (EditableAnchor)this.selected;
            if (this.anchors.get(editableAnchor.name) == null) {
                return false;
            }
            ((LinkEditor)this.viewer).commandBar.setModified();
            this.getMgr().remove(editableAnchor);
            this.anchors.remove(editableAnchor.name);
            this.curText = editableAnchor.name;
            this.selected = null;
            int n = 20;
            this.repaint(editableAnchor.x - n / 2, editableAnchor.y - n / 2, n, n);
            return true;
        }
        return false;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        graphics.translate(-this.dx, -this.dy);
        this.drawImage(graphics);
        if (this.image != null) {
            if (this.editMode.equals(EM_NORMAL)) {
                this.drawNormal(graphics);
                return;
            }
            if (this.editMode.equals(EM_LINK)) {
                this.drawLink(graphics);
                return;
            }
            if (this.editMode.equals(EM_ANCHOR)) {
                this.drawAnchor(graphics);
            }
        }
    }

    public void drawLink(Graphics graphics) {
        if (this.annotations != null) {
            this.getMgr().drawLinks(graphics, EXISTING, this.factor);
        }
        if (this.selected != null && ((EditableRegion)this.selected).area != null) {
            graphics.setColor(SELECT);
            Rectangle rectangle = this.makeDrawable(((EditableRegion)this.selected).area);
            graphics.drawRect(this.scale(rectangle.x), this.scale(rectangle.y), this.scale(rectangle.width) - 1, this.scale(rectangle.height) - 1);
        }
    }

    public void drawAnchor(Graphics graphics) {
        if (this.annotations != null) {
            this.getMgr().drawAnchors(graphics, EXISTING, this.factor);
        }
        if (this.selected != null) {
            this.selected.editDraw(graphics, SELECT, this.factor);
        }
    }
}

