/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.client.ClientCanvas;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

class ZoomSelectPanel
extends Panel {
    static final String LABEL = "Label";
    static final String CHOICE = "Choice";
    static final String CUSTOM = "Custom";
    static double[] vf = new double[]{-1.0, -1.0, -1.0, 0.1, 0.25, 0.3333333333333333, 0.5, 0.75, 1.0, 1.5, 2.0};
    ClientCanvas canvas;
    CardLayout layout;
    Choice choice;
    Button label;
    TextField text;
    float factor = 1.0f;
    String lastSelected = "100%";
    String active;

    String percentString() {
        return Integer.toString(this.percent());
    }

    public ZoomSelectPanel(ClientCanvas clientCanvas) {
        this.canvas = clientCanvas;
        this.label = new Button("Zoom: " + this.percentString() + "%");
        Panel panel = new Panel();
        panel.add(this.label);
        this.text = new TextField("100", 3);
        this.text.setEditable(true);
        Panel panel2 = new Panel();
        panel2.add(this.text);
        panel2.add(new Label("%"));
        this.choice = new Choice();
        this.choice.addItem(CUSTOM);
        this.choice.addItem("Page Width");
        this.choice.addItem("Whole Page");
        this.choice.addItem("10%");
        this.choice.addItem("25%");
        this.choice.addItem("33%");
        this.choice.addItem("50%");
        this.choice.addItem("75%");
        this.choice.addItem("100%");
        this.choice.addItem("150%");
        this.choice.addItem("200%");
        this.choice.select("100%");
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.add(LABEL, panel);
        this.add(CHOICE, this.choice);
        this.add(CUSTOM, panel2);
        this.changeCard(LABEL);
    }

    int percent() {
        return (int)(100.0 * (double)this.factor + 0.5);
    }

    void changeCard(String string) {
        this.layout.show(this, string);
        this.active = string;
    }

    void revert() {
        this.changeCard(LABEL);
        this.select(this.factor);
    }

    public boolean lostFocus(Event event, Object object) {
        if (this.active == CHOICE) {
            this.revert();
        }
        return super.lostFocus(event, object);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.choice) {
            return this.DoChoice();
        }
        if (event.target == this.text) {
            return this.DoText();
        }
        if (event.target == this.label) {
            this.changeCard(CHOICE);
            return true;
        }
        if (event.target == this.canvas) {
            return this.DoCanvas((Float)object);
        }
        return super.action(event, object);
    }

    boolean DoChoice() {
        int n = this.choice.getSelectedIndex();
        String string = this.choice.getSelectedItem();
        if (string.equals(CUSTOM)) {
            this.changeCard(CUSTOM);
            ((TextComponent)this.text).setText(Integer.toString(this.percent()));
            this.text.selectAll();
            this.text.requestFocus();
            return true;
        }
        float f = string.equals("Page Width") ? this.canvas.ZoomPageWidthFactor() : (string.equals("Whole Page") ? this.canvas.ZoomWholePageFactor() : (float)vf[n]);
        return this.UpdateFactor(f);
    }

    boolean DoText() {
        String string = this.text.getText();
        try {
            float f = Integer.parseInt(string);
            if (f <= 0.0f) {
                throw new NumberFormatException("Negative Number");
            }
            return this.UpdateFactor((float)((double)f / 100.0));
        }
        catch (NumberFormatException numberFormatException) {
            this.revert();
            return true;
        }
    }

    boolean DoCanvas(Float f) {
        this.factor = f.floatValue();
        this.updateLabel();
        this.changeCard(LABEL);
        this.select(f.floatValue());
        this.validate();
        return true;
    }

    void select(float f) {
        boolean bl = true;
        int n = 0;
        n = 0;
        while (n < vf.length) {
            if (f == (float)vf[n]) {
                this.choice.select(n);
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            this.choice.select(CUSTOM);
        }
    }

    boolean UpdateFactor(float f) {
        this.postEvent(new Event(this, 1001, new Float(f)));
        return true;
    }

    void updateLabel() {
        this.label.setLabel("Zoom: " + this.percentString() + "%");
        this.label.invalidate();
        this.label.validate();
    }
}

