/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.client.ZoomCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Vector;

public class ZoomFrame
extends Frame {
    ZoomCanvas canvas;
    Button bOk;
    double factor;
    Image image;
    Vector dimension;
    int width;
    int height;

    public ZoomFrame(Image image, int n, int n2, int n3, int n4, double d) {
        this(image, n, n2, n3, n4, n3, n4, d);
    }

    public ZoomFrame(Image image, int n, int n2, int n3, int n4, int n5, int n6, double d) {
        super("factor: " + d);
        this.image = image;
        this.factor = d;
        this.width = n5;
        this.height = n6;
        this.bOk = new Button("  Ok  ");
        this.canvas = new ZoomCanvas(image, n, n2, n3, n4, d);
        this.DoLayout();
    }

    public void DoLayout() {
        Panel panel = new Panel();
        panel.add(this.bOk);
        this.removeAll();
        ((Component)this).invalidate();
        this.setLayout(new BorderLayout());
        this.add("Center", this.canvas);
        this.add("South", panel);
        this.validate();
        this.pack();
    }

    public boolean handleEvent(Event event) {
        if (event.id != 201) {
            return super.handleEvent(event);
        }
        this.CloseWindow();
        return false;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.bOk) {
            this.CloseWindow();
        } else if (event.target == this.canvas) {
            this.DoZoomIn((Rectangle)object);
        } else {
            return false;
        }
        return true;
    }

    public void CloseWindow() {
        this.canvas = null;
        this.bOk = null;
        this.dispose();
        ((Component)this).hide();
    }

    public void DoZoomIn(Rectangle rectangle) {
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        if (rectangle.x + rectangle.width > this.width) {
            rectangle.width = this.width - rectangle.x;
        }
        if (rectangle.y + rectangle.height > this.height) {
            rectangle.height = this.height - rectangle.y;
        }
        this.factor *= 2.0;
        this.DoZoom();
    }

    public void DoZoom() {
        Rectangle rectangle = (Rectangle)this.dimension.lastElement();
        this.setTitle("factor: " + this.factor);
        this.canvas = new ZoomCanvas(this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.factor);
        this.DoLayout();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.pack();
    }
}

