/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;

public class ZoomCanvas
extends Canvas {
    static int MAX_DIMENSION = 480;
    Image image;
    double factor = 1.0;
    Dimension size;
    Rectangle window;
    int tx;
    int ty;

    public ZoomCanvas(Image image, int n, int n2, int n3, int n4, double d) {
        int n5 = n3;
        int n6 = n4;
        int n7 = (int)(d * (double)n5);
        int n8 = (int)(d * (double)n6);
        this.size = new Dimension(n7, n8);
        this.tx = (int)((double)(n3 - n5) / 2.0) + n;
        this.ty = (int)((double)(n4 - n6) / 2.0) + n2;
        CropImageFilter cropImageFilter = new CropImageFilter(this.tx, this.ty, n5, n6);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), cropImageFilter);
        this.image = this.createImage(filteredImageSource);
        this.prepareImage(this.image, this.size.width, this.size.height, this);
        this.factor = d;
    }

    public void changeWindow(Rectangle rectangle) {
        Rectangle rectangle2;
        if (this.window != null) {
            rectangle2 = this.makeDrawable(this.window);
            this.window = null;
            this.repaint(rectangle2.x, rectangle2.y, rectangle2.width + 1, rectangle2.height + 1);
        }
        if (rectangle != null) {
            this.window = rectangle;
            rectangle2 = this.makeDrawable(this.window);
            this.repaint(rectangle2.x, rectangle2.y, rectangle2.width + 1, rectangle2.height + 1);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.modifiers != 4) {
            this.changeWindow(new Rectangle(n, n2, 0, 0));
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.window != null) {
            int n3 = n - this.window.x;
            int n4 = n2 - this.window.y;
            this.changeWindow(new Rectangle(this.window.x, this.window.y, n3, n4));
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.window != null && event.modifiers != 4) {
            this.window = this.makeDrawable(this.window);
            return this.postEvent(new Event(this, 1001, this.getWindow()));
        }
        if (this.window != null) {
            this.changeWindow(null);
            return true;
        }
        return false;
    }

    public Rectangle makeDrawable(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (n3 < 0) {
            n3 = -n3;
            n -= n3;
        }
        if (n4 < 0) {
            n4 = -n4;
            n2 -= n4;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public Rectangle getWindow() {
        int n = (int)((double)this.window.x / this.factor + 0.5) + this.tx;
        int n2 = (int)((double)this.window.y / this.factor + 0.5) + this.ty;
        int n3 = (int)((double)this.window.width / this.factor);
        int n4 = (int)((double)this.window.height / this.factor);
        return new Rectangle(n, n2, n3, n4);
    }

    public Dimension minimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension preferredSize() {
        return this.size;
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this.size.width, this.size.height, this);
        if (this.window != null) {
            Rectangle rectangle = this.makeDrawable(this.window);
            graphics.setColor(Color.red);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

