/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.thumbnails.Thumbnail;
import COM.xerox.digipaper.util.CanBeNotified;
import COM.xerox.digipaper.util.CanGetObjects;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import COM.xerox.digipaper.util.GeneralSemaphore;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;

public class ThumbnailViewer
extends Frame
implements CanBeNotified {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected static int THUMBNAIL_CACHE_SIZE = 25;
    protected int rows = 2;
    protected int cols = 3;
    protected int showing = 6;
    protected int old_start = -1;
    protected int old_end = -1;
    protected Panel pThumb;
    protected Scrollbar scrollbar;
    protected Label message;
    protected String location;
    protected Button bOk;
    protected XIFFFile file;
    protected GeneralSemaphore sync;
    protected CanGetObjects getter;
    protected Thumbnail tmp_thumbnail;

    public ThumbnailViewer(String string, XIFFFile xIFFFile, CanGetObjects canGetObjects) {
        super(string);
        this.getter = canGetObjects;
        this.file = xIFFFile;
        this.pThumb = new Panel();
        this.scrollbar = new Scrollbar();
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.bOk = new Button(" Ok ");
        panel.add("East", this.bOk);
        this.message = new Label("no thumbnails yet");
        panel.add("Center", this.message);
        this.pThumb.setLayout(new GridLayout(this.rows, this.cols));
        this.setLayout(new BorderLayout());
        this.add("Center", this.pThumb);
        this.add("East", this.scrollbar);
        this.add("South", panel);
        this.sync = new GeneralSemaphore();
        canGetObjects = null;
    }

    public int getNumShowing() {
        return this.showing;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.bOk) {
            this.CloseWindow();
            return true;
        }
        return false;
    }

    public void CloseWindow() {
        dbg.dprint("ThumbnailViewer::CloseWindow() starts", DebugInfoPrinter.DBUG_THUMBNAILS);
        this.pThumb = null;
        this.message = null;
        this.scrollbar = null;
        this.bOk = null;
        ((Component)this).hide();
        this.dispose();
        if (this.old_start > 0) {
            this.stopThumbnailGetter(this.old_start, this.old_end);
        }
    }

    protected synchronized Thumbnail getThumbnail(int n) {
        dbg.dprint("ThumbnailViewer::getThumbnail() starts", DebugInfoPrinter.DBUG_THUMBNAILS);
        Integer n2 = new Integer(n);
        this.tmp_thumbnail = null;
        if (!this.getter.startGettingObject(this, n2)) {
            return null;
        }
        this.sync.P();
        dbg.dprint("ThumbnailViewer::getThumbnail() ends", DebugInfoPrinter.DBUG_THUMBNAILS);
        return this.tmp_thumbnail;
    }

    public synchronized void Update(boolean bl, Object object, Object object2) {
        dbg.dprint("ThumbnailViewer::Update() starts", DebugInfoPrinter.DBUG_THUMBNAILS);
        this.tmp_thumbnail = (Thumbnail)object2;
        this.sync.V();
        dbg.dprint("ThumbnailViewer::Update() ends", DebugInfoPrinter.DBUG_THUMBNAILS);
    }

    public void stopThumbnailGetter(int n, int n2) {
        dbg.dprint("ThumbnailViewer::stopThumbnailGetter() starts", DebugInfoPrinter.DBUG_THUMBNAILS);
        int n3 = n;
        while (n3 <= n2) {
            Integer n4 = new Integer(n3);
            this.getter.stopGettingObject(this, n4);
            ++n3;
        }
        System.gc();
    }

    private int scrollMax() {
        return (int)((double)((float)this.file.getNumPages() / (float)this.cols) + 0.5) - this.rows;
    }

    public void updateScrollbar(int n) {
        int n2 = this.file.getNumPages();
        if (n2 <= this.showing) {
            this.scrollbar.hide();
            this.scrollbar.setValue(0);
            this.drawThumbnails(0, this.showing);
            ((Component)this).invalidate();
            this.validate();
            return;
        }
        this.scrollbar.show();
        this.scrollbar.setValues(0, this.rows, 0, this.scrollMax());
        this.DoScrollbar(n);
    }

    public synchronized void DoScrollbar(int n) {
        if (n > this.scrollMax()) {
            n = this.scrollMax();
        } else if (n < 0) {
            n = 0;
        }
        this.drawThumbnails(n * this.cols, n * this.cols + this.showing - 1);
    }

    protected void drawThumbnails(int n, int n2) {
        int n3 = -7;
        this.pThumb.removeAll();
        if (this.old_start >= 0) {
            this.stopThumbnailGetter(this.old_start, this.old_end);
        }
        this.old_start = n;
        this.old_end = n2;
        int n4 = n;
        while (n4 <= n2) {
            Thumbnail thumbnail = this.getThumbnail(n4);
            if (thumbnail == null) {
                this.pThumb.add(new Canvas());
                if (n3 == -7) {
                    n3 = n4 - 1;
                }
            } else {
                this.pThumb.add(thumbnail);
            }
            ++n4;
        }
        if (n3 == -7) {
            n3 = n2;
        }
        this.location = "Pages " + (n + 1) + " to " + (n3 + 1);
        this.message.setText(this.location);
        ((Component)this).invalidate();
        this.validate();
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (event.target instanceof Thumbnail) {
            this.message.setText(((Thumbnail)event.target).getPageNum() + 1 + " of " + this.file.getNumPages());
        } else {
            this.message.setText(this.location);
        }
        return true;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.DoScrollbar((Integer)event.arg);
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public synchronized void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.pThumb.size().width;
        int n2 = this.pThumb.size().height;
        int n3 = (int)((double)n2 / (double)(Thumbnail.MAX_SIZE + 3));
        int n4 = (int)((double)n / (double)(Thumbnail.MAX_SIZE + 3));
        if (n3 != this.rows || n4 != this.cols) {
            int n5 = this.showing;
            this.rows = n3;
            this.cols = n4;
            this.showing = this.rows * this.cols;
            if (this.showing > this.file.getNumPages() && n5 > this.file.getNumPages()) {
                this.scrollbar.show();
                this.repaint();
                return;
            }
            this.pThumb.removeAll();
            this.pThumb.setLayout(new GridLayout(this.rows, this.cols));
            ((Component)this.pThumb).invalidate();
            this.updateScrollbar(this.scrollbar.getValue());
        }
    }
}

